/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.math;

import com.mrbysco.captcha.platform.Services;
import java.util.Random;
import java.util.function.Supplier;

public enum MathOperation {
    ADDITION("+", Services.PLATFORM::getAdditionMaxX, Services.PLATFORM::getAdditionMaxY),
    SUBTRACTION("-", Services.PLATFORM::getSubtractionMaxX, Services.PLATFORM::getAdditionMaxY),
    MULTIPLICATION("*", Services.PLATFORM::getMultiplicationMaxX, Services.PLATFORM::getMultiplicationMaxY),
    DIVISION("/", Services.PLATFORM::getDivisionMaxX, Services.PLATFORM::getDivisionMaxY);

    private final String symbol;
    private final Supplier<Integer> maxX;
    private final Supplier<Integer> maxY;

    private MathOperation(String symbol, Supplier<Integer> maxX, Supplier<Integer> maxY) {
        this.symbol = symbol;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public double generateX() {
        return (int)(Math.random() * (double)this.maxX.get().intValue());
    }

    public double generateY() {
        return (int)(Math.random() * (double)this.maxY.get().intValue());
    }

    public double getAnswer(double x, double y) {
        return switch (this.ordinal()) {
            case 0 -> x + y;
            case 1 -> x - y;
            case 2 -> x * y;
            case 3 -> x / y;
            default -> 0.0;
        };
    }

    public static MathOperation getRandomOperation(Random random) {
        int pick = random.nextInt(MathOperation.values().length);
        return MathOperation.values()[pick];
    }
}

