/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.slide;

import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.image.ImageEnum;
import com.mrbysco.captcha.client.screen.slide.PuzzleSlider;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class SlideScreen
extends CaptchaScreen {
    private static final Random random = new Random();
    private class_2960 IMAGE = class_2960.method_60655((String)"captcha", (String)"textures/gui/amethyst.png");
    protected int puzzleY;
    protected int puzzleX = 16;
    protected double acceptedMin;
    protected double acceptedMax;
    protected PuzzleSlider slider;
    protected int attemptCount = 0;

    public SlideScreen(String code, int maxCompletionTime) {
        super((class_2561)class_2561.method_43471((String)"captcha.slide.screen"), code, maxCompletionTime);
        this.resetPuzzle();
    }

    private void resetPuzzle() {
        ImageEnum image = ImageEnum.getRandom(random, ImageEnum.SANDY, ImageEnum.VEHICLE);
        this.IMAGE = class_2960.method_60655((String)"captcha", (String)("textures/gui/" + image.getImageName() + ".png"));
        OptionalInt randomNumber = random.ints(32, 85).findFirst();
        this.puzzleX = randomNumber.isPresent() ? randomNumber.getAsInt() : 32;
        this.acceptedMin = (double)this.puzzleX - 0.1 - 16.0;
        this.acceptedMax = (double)this.puzzleX + 0.4 - 16.0;
        randomNumber = random.ints(32, 85).findFirst();
        int n = this.puzzleY = randomNumber.isPresent() ? randomNumber.getAsInt() : 32;
        if (this.slider != null) {
            this.slider.setValue(0.0);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.slider = new PuzzleSlider(this.field_22789 / 2 - 100, this.field_22790 / 2 + 100, 200, 20, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), 0.0, 84.0, 0.0, 0.1, 0, slider -> {
            double sliderValue = slider.getValue();
            if (sliderValue >= this.acceptedMin && sliderValue <= this.acceptedMax) {
                this.completeCaptcha();
            }
            ++this.attemptCount;
            if (this.attemptCount >= 20) {
                this.completeCaptcha();
            }
        });
        this.method_37063((class_364)this.slider);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.resetCaptcha();
        }
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.resetPuzzle();
        }
    }

    @Override
    public int getMaxCompletionTime() {
        return super.getMaxCompletionTime();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        int pieceX = this.field_22789 / 2 - 100 + this.puzzleX * 2 - 32;
        int pieceY = this.field_22790 / 2 - 100 + this.puzzleY * 2 - 32;
        guiGraphics.method_25296(pieceX, pieceY, pieceX + 32, pieceY + 32, -1509949440, -1509949440);
        int sliderX = this.field_22789 / 2 - 100 + (int)(this.slider.getValue() * 2.0);
        guiGraphics.method_25290(class_10799.field_56883, this.IMAGE, sliderX, pieceY, (float)(this.puzzleX * 2 - 32), (float)(this.puzzleY * 2 - 32), 32, 32, 200, 200);
        guiGraphics.method_25296(sliderX, pieceY, sliderX + 32, pieceY + 32, 0x1AFFFFFF, 0x1AFFFFFF);
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25290(class_10799.field_56883, this.IMAGE, this.field_22789 / 2 - 100, this.field_22790 / 2 - 100, 0.0f, 0.0f, 200, 200, 200, 200);
    }
}

