/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.captcha.client.CaptchaEnum;
import com.mrbysco.captcha.platform.Services;
import com.mrbysco.captcha.util.CaptchaManager;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class CaptchaCommands {
    public static void initializeCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"captcha");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"forceCaptcha").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"captchaName", (ArgumentType)StringArgumentType.word()).suggests((cs, builder) -> {
            ArrayList<String> captchaNames = new ArrayList<String>();
            for (CaptchaEnum eCaptcha : CaptchaEnum.values()) {
                captchaNames.add(eCaptcha.getCaptchaName());
            }
            return class_2172.method_9265(captchaNames, (SuggestionsBuilder)builder);
        }).executes(CaptchaCommands::forceCaptcha))));
        dispatcher.register(root);
    }

    private static int forceCaptcha(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String captchaName = StringArgumentType.getString(ctx, (String)"captchaName");
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            UUID uuid = player.method_5667();
            CaptchaManager.forgetUser(uuid);
            String code = CaptchaManager.applyRandomCode(uuid);
            Services.PLATFORM.sendRequireCaptchaMessage(player, captchaName, code);
        }
        return 0;
    }
}

