/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.config;

import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="captcha")
public class CaptchaConfigFabric
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public General general = new General();
    @ConfigEntry.Gui.CollapsibleObject
    public Math math = new Math();
    @ConfigEntry.Gui.CollapsibleObject
    public Text text = new Text();

    public static class General {
        @Comment(value="Defines the amount of ticks at the start of a world where no captcha's get requested [Default: 6000]")
        public int gracePeriod = 6000;
        @Comment(value="Defines the amount of time in seconds in which the captcha should be solved [Default: 15]")
        @ConfigEntry.BoundedDiscrete(min=1L, max=0x7FFFFFFFL)
        public int captchaTime = 15;
        @Comment(value="Defines the cooldown between captcha requests in seconds [Default: 900 (15 minutes)]")
        @ConfigEntry.BoundedDiscrete(min=30L, max=0x7FFFFFFFL)
        public int captchaCooldown = 900;
    }

    public static class Math {
        @Comment(value="Defines the max the first number can be in the addition problem [Default: 100]")
        public int additionMaxX = 100;
        @Comment(value="Defines the max the second number can be in the addition problem [Default: 100]")
        @ConfigEntry.BoundedDiscrete(min=30L, max=0x7FFFFFFFL)
        public int additionMaxY = 100;
        @Comment(value="Defines the max the first number can be in the subtraction problem [Default: 100]")
        public int subtractionMaxX = 100;
        @Comment(value="Defines the max the second number can be in the subtraction problem [Default: 100]")
        @ConfigEntry.BoundedDiscrete(min=30L, max=0x7FFFFFFFL)
        public int subtractionMaxY = 100;
        @Comment(value="Defines the max the first number can be in the multiplication problem [Default: 20]")
        public int multiplicationMaxX = 30;
        @Comment(value="Defines the max the second number can be in the multiplication problem [Default: 20]")
        @ConfigEntry.BoundedDiscrete(min=20L, max=0x7FFFFFFFL)
        public int multiplicationMaxY = 20;
        @Comment(value="Defines the max the first number can be in the division problem [Default: 100]")
        @ConfigEntry.BoundedDiscrete(min=1L, max=0x7FFFFFFFL)
        public int divisionMaxX = 100;
        @Comment(value="Defines the max the second number can be in the division problem [Default: 100]")
        @ConfigEntry.BoundedDiscrete(min=30L, max=0x7FFFFFFFL)
        public int divisionMaxY = 100;
    }

    public static class Text {
        @Comment(value="List of words that can be used to generate a text captcha (16 character length max)")
        public List<String> textCaptchaWords = List.of("diamond", "iron", "gold", "emerald", "lapis", "coal", "redstone", "nether", "creeper", "skeleton", "spider", "zombie", "enderman", "endermite", "slime", "ghast", "pig", "cow", "sheep", "chicken", "rabbit", "mooshroom", "villager", "witch", "wither", "blaze", "guardian", "shulker", "ender dragon", "wither", "drowned", "husk", "stray", "phantom", "zoglin", "piglin", "panda", "bee", "cat", "fox", "ocelot");
    }
}

