/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.util;

import com.mrbysco.captcha.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public class CaptchaManager {
    private static final Map<UUID, Long> captchaMap = new HashMap<UUID, Long>();
    private static final Map<UUID, String> activeMap = new HashMap<UUID, String>();

    public static boolean completedCaptchaRecently(UUID uuid) {
        if (captchaMap.containsKey(uuid)) {
            long lastCompleted = captchaMap.get(uuid);
            long currentTime = System.currentTimeMillis();
            return currentTime - lastCompleted < (long)Services.PLATFORM.getCaptchaCooldown() * 1000L;
        }
        return false;
    }

    public static String getActiveCode(UUID uuid) {
        return activeMap.get(uuid);
    }

    public static String applyRandomCode(UUID uuid) {
        String code = CaptchaManager.generateRandomCode();
        activeMap.put(uuid, code);
        return code;
    }

    public static String generateRandomCode() {
        return RandomStringUtils.secure().nextAlphanumeric(10);
    }

    public static void setCompletedRecently(UUID uuid, String code) {
        if (activeMap.containsKey(uuid) && activeMap.get(uuid).equals(code)) {
            activeMap.remove(uuid);
            captchaMap.put(uuid, System.currentTimeMillis());
        }
    }

    public static void forgetUser(UUID uuid) {
        activeMap.remove(uuid);
        captchaMap.remove(uuid);
    }
}

