/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha;

import com.mojang.brigadier.CommandDispatcher;
import com.mrbysco.captcha.CommonClass;
import com.mrbysco.captcha.commands.CaptchaCommands;
import com.mrbysco.captcha.config.CaptchaConfigNeoForge;
import com.mrbysco.captcha.network.NetworkHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@Mod(value="captcha")
public class CaptchaNeoForge {
    public CaptchaNeoForge(IEventBus eventBus, ModContainer container, Dist dist) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CaptchaConfigNeoForge.commonSpec);
        CommonClass.init();
        eventBus.addListener(NetworkHandler::setupPackets);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        NeoForge.EVENT_BUS.addListener(this::onPlayerTick);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void onCommandRegister(RegisterCommandsEvent event) {
        CaptchaCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onPlayerTick(PlayerTickEvent.Post event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && !(player = (ServerPlayer)player2).isCreative() && !player.isSpectator()) {
            CommonClass.onPlayerTick((Player)player);
        }
    }
}

