/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client;

import com.mrbysco.captcha.client.CaptchaEnum;
import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.NotARobotScreen;
import com.mrbysco.captcha.client.screen.WinRARScreen;
import com.mrbysco.captcha.client.screen.image.ImageScreen;
import com.mrbysco.captcha.client.screen.math.MathScreen;
import com.mrbysco.captcha.client.screen.slide.SlideScreen;
import com.mrbysco.captcha.client.screen.text.TextScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class ScreenHandler {
    public static void openCaptcha(String captchaName, String code, int maxCompletionTime, List<? extends String> configuredWords) {
        Minecraft mc = Minecraft.getInstance();
        if (!(mc.screen instanceof CaptchaScreen)) {
            ScreenHandler.setScreen(CaptchaEnum.getByName(captchaName), code, maxCompletionTime, configuredWords);
        }
    }

    public static void setScreen(CaptchaEnum captcha, String code, int maxCompletionTime, List<? extends String> configuredWords) {
        switch (captcha) {
            case MATH: {
                Minecraft.getInstance().setScreen((Screen)new MathScreen(code, maxCompletionTime));
                break;
            }
            case TEXT: {
                Minecraft.getInstance().setScreen((Screen)new TextScreen(code, maxCompletionTime, configuredWords));
                break;
            }
            case IMAGE: {
                Minecraft.getInstance().setScreen((Screen)new ImageScreen(code, maxCompletionTime));
                break;
            }
            case SLIDE: {
                Minecraft.getInstance().setScreen((Screen)new SlideScreen(code, maxCompletionTime));
                break;
            }
            case WINRAR: {
                Minecraft.getInstance().setScreen((Screen)new WinRARScreen(code, maxCompletionTime));
                break;
            }
            default: {
                Minecraft.getInstance().setScreen((Screen)new NotARobotScreen(code, maxCompletionTime));
            }
        }
    }
}

