/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen;

import com.mrbysco.captcha.platform.Services;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class CaptchaScreen
extends Screen {
    private final String code;
    protected int timeWaited;
    protected int messageY = 70;
    private final int maxCompletionTime;
    protected MultiLineLabel message = MultiLineLabel.EMPTY;

    protected CaptchaScreen(Component component, String code, int maxCompletionTime) {
        super(component);
        this.code = code;
        this.maxCompletionTime = maxCompletionTime;
    }

    public void tick() {
        super.tick();
        ++this.timeWaited;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderMessage(guiGraphics);
    }

    public void renderMessage(GuiGraphics guiGraphics) {
        this.message.render(guiGraphics, MultiLineLabel.Align.CENTER, this.width / 2, this.messageY, 10, false, ARGB.opaque((int)0));
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public int getMaxCompletionTime() {
        return this.maxCompletionTime * 20;
    }

    public void completeCaptcha() {
        this.minecraft.setScreen(null);
        Services.PLATFORM.sendCompletedCaptchaMessage(this.code);
    }

    public void resetCaptcha() {
        this.timeWaited = 0;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

