/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen;

import com.mrbysco.captcha.client.screen.CaptchaScreen;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class WinRARScreen
extends CaptchaScreen {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)"textures/gui/popup.png");
    protected int imageWidth = 256;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;

    public WinRARScreen(String code, int maxCompletionTime) {
        super((Component)Component.translatable((String)"captcha.winrar.screen"), code, maxCompletionTime);
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.message = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.winrar.message1"), Component.translatable((String)"captcha.winrar.message2"), Component.translatable((String)"captcha.winrar.message3"), Component.translatable((String)"captcha.winrar.message4"), Component.translatable((String)"captcha.winrar.message5"), Component.translatable((String)"captcha.winrar.message6")});
        int yOffset = 24;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"captcha.winrar.buy"), button -> Util.getPlatform().openUri("https://en.wikipedia.org/wiki/WinRAR#License")).bounds(this.width / 2 + 40, this.topPos + yOffset, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"captcha.winrar.how"), button -> Util.getPlatform().openUri("https://www.youtube.com/watch?v=dQw4w9WgXcQ")).bounds(this.width / 2 + 40, this.topPos + (yOffset += 22), 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"captcha.winrar.close"), button -> this.completeCaptcha()).bounds(this.width / 2 + 40, this.topPos + (yOffset += 22), 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"captcha.winrar.help"), button -> Util.getPlatform().openUri("https://www.curseforge.com/minecraft/mc-mods/captcha")).bounds(this.width / 2 + 40, this.topPos + (yOffset += 22), 80, 20).build());
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.hLine(this.leftPos + 3, this.leftPos + this.imageWidth - 4, this.topPos + 18, -1);
        guiGraphics.drawString(this.font, this.title, this.leftPos + 8, this.topPos + 6, ARGB.opaque((int)0x404040), false);
        this.renderMessage(guiGraphics);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    @Override
    public void renderMessage(GuiGraphics guiGraphics) {
        guiGraphics.hLine(this.leftPos + 8, this.leftPos + 160, this.topPos + 30, -6250336);
        guiGraphics.vLine(this.leftPos + 8, this.topPos + 30, this.topPos + 100, -6250336);
        this.message.render(guiGraphics, MultiLineLabel.Align.LEFT, this.leftPos + 16, this.topPos + 36, 10, false, ARGB.opaque((int)0));
        guiGraphics.vLine(this.leftPos + 160, this.topPos + 30, this.topPos + 100, -6250336);
        guiGraphics.hLine(this.leftPos + 8, this.leftPos + 160, this.topPos + 100, -6250336);
    }
}

