/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.image;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public enum ImageEnum {
    AMETHYST("amethyst", ImageEnum.generateAmethyst()),
    BEE("bee", ImageEnum.generateBees()),
    END("end", ImageEnum.generateEnd()),
    ICY("icy", ImageEnum.generateIcy()),
    PLAINS("plains", ImageEnum.generatePlains()),
    PORTAL("portal", ImageEnum.generatePortal()),
    SANDY("sandy", ImageEnum.generateSandy()),
    VEHICLE("vehicle", ImageEnum.generateVehicle());

    private final String imageName;
    private final Map<String, boolean[][]> dataMap;

    private ImageEnum(String imageName, Map<String, boolean[][]> dataMap) {
        this.imageName = imageName;
        this.dataMap = dataMap;
    }

    public String getImageName() {
        return this.imageName;
    }

    public Map<String, boolean[][]> getDataMap() {
        return this.dataMap;
    }

    private static Map<String, boolean[][]> generateAmethyst() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] budding = new boolean[][]{{false, false, false, false}, {true, false, false, true}, {false, true, true, false}, {true, true, false, false}};
        dataMap.put("Budding Amethyst", budding);
        boolean[][] cluster = new boolean[][]{{false, false, false, false}, {false, false, false, false}, {true, true, false, false}, {true, true, false, false}};
        dataMap.put("Amethyst Cluster", cluster);
        return dataMap;
    }

    private static Map<String, boolean[][]> generateBees() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] bees = new boolean[][]{{false, false, false, false}, {false, false, true, true}, {false, false, false, false}, {true, false, false, false}};
        dataMap.put("Bees", bees);
        boolean[][] hives = new boolean[][]{{false, false, false, false}, {false, false, false, true}, {false, true, false, false}, {false, true, false, false}};
        dataMap.put("Beehives", hives);
        boolean[][] flowers = new boolean[][]{{true, false, false, false}, {true, true, false, false}, {true, false, false, false}, {true, false, false, false}};
        dataMap.put("Flowers", flowers);
        boolean[][] leaves = new boolean[][]{{true, true, true, true}, {true, true, true, true}, {true, true, true, true}, {false, false, false, false}};
        dataMap.put("Leaves", leaves);
        boolean[][] birch = new boolean[][]{{false, true, false, false}, {false, true, false, false}, {false, false, false, false}, {false, false, false, false}};
        dataMap.put("Birch Trees", birch);
        return dataMap;
    }

    private static Map<String, boolean[][]> generateEnd() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] city = new boolean[][]{{true, true, true, true}, {true, true, true, false}, {true, true, true, true}, {false, false, true, true}};
        dataMap.put("End City", city);
        boolean[][] chorus = new boolean[][]{{false, false, false, false}, {false, true, true, true}, {true, true, true, false}, {true, true, false, false}};
        dataMap.put("Chorus plants", chorus);
        boolean[][] banner = new boolean[][]{{true, false, false, false}, {false, false, false, false}, {false, false, true, false}, {false, false, false, false}};
        dataMap.put("Banners", banner);
        return dataMap;
    }

    private static Map<String, boolean[][]> generateIcy() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] ice = new boolean[][]{{false, false, false, false}, {false, false, true, true}, {false, true, true, true}, {true, true, true, true}};
        dataMap.put("Ice", ice);
        boolean[][] animals = new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}};
        dataMap.put("Animals", animals);
        return dataMap;
    }

    private static Map<String, boolean[][]> generatePlains() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] pumpkins = new boolean[][]{{false, false, false, false}, {true, true, false, false}, {true, true, false, false}, {false, false, false, false}};
        dataMap.put("Pumpkins", pumpkins);
        boolean[][] horse = new boolean[][]{{false, false, false, false}, {false, false, false, true}, {false, false, true, false}, {false, false, false, false}};
        dataMap.put("Horses", horse);
        boolean[][] flowers = new boolean[][]{{true, true, true, false}, {false, true, true, false}, {false, false, false, false}, {false, false, false, false}};
        dataMap.put("Flowers", flowers);
        return dataMap;
    }

    private static Map<String, boolean[][]> generatePortal() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] magma = new boolean[][]{{false, false, false, false}, {false, true, true, false}, {true, true, true, true}, {true, false, false, false}};
        dataMap.put("Magma", magma);
        boolean[][] obsidian = new boolean[][]{{false, false, false, false}, {false, true, true, false}, {false, true, true, false}, {false, false, false, false}};
        dataMap.put("Obsidian", obsidian);
        boolean[][] water = new boolean[][]{{true, true, true, true}, {true, true, true, true}, {true, false, false, true}, {true, false, true, true}};
        dataMap.put("Water", water);
        return dataMap;
    }

    private static Map<String, boolean[][]> generateSandy() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] water = new boolean[][]{{true, false, false, false}, {true, false, false, true}, {false, false, false, false}, {false, false, true, true}};
        dataMap.put("Water", water);
        boolean[][] lava = new boolean[][]{{false, false, false, false}, {false, true, false, false}, {false, false, false, false}, {false, false, false, false}};
        dataMap.put("Lava", lava);
        boolean[][] snow = new boolean[][]{{false, true, false, false}, {false, false, false, false}, {false, false, true, false}, {false, false, false, false}};
        dataMap.put("Snow", snow);
        boolean[][] empty = new boolean[][]{{false, false, false, false}, {false, false, true, false}, {true, false, false, false}, {true, true, false, false}};
        dataMap.put("Empty Cauldrons", empty);
        boolean[][] turtle = new boolean[][]{{false, false, false, true}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}};
        dataMap.put("Turtles", turtle);
        return dataMap;
    }

    private static Map<String, boolean[][]> generateVehicle() {
        HashMap<String, boolean[][]> dataMap = new HashMap<String, boolean[][]>();
        boolean[][] chest = new boolean[][]{{true, false, false, false}, {true, false, false, false}, {false, false, true, false}, {false, false, false, false}};
        dataMap.put("Chests", chest);
        boolean[][] boats = new boolean[][]{{true, true, false, false}, {false, false, false, false}, {false, false, false, true}, {false, false, true, false}};
        dataMap.put("Boats", boats);
        boolean[][] carts = new boolean[][]{{false, false, false, false}, {true, false, false, false}, {false, false, true, false}, {false, false, false, false}};
        dataMap.put("Minecarts", carts);
        boolean[][] leaves = new boolean[][]{{false, false, false, false}, {false, true, false, true}, {false, true, false, true}, {false, true, false, false}};
        dataMap.put("Leaves", leaves);
        boolean[][] water = new boolean[][]{{true, false, true, true}, {false, false, false, true}, {true, false, true, false}, {true, true, true, true}};
        dataMap.put("Water", water);
        boolean[][] regular = new boolean[][]{{false, true, false, false}, {false, false, false, false}, {false, false, false, true}, {false, false, true, false}};
        dataMap.put("Regular Boats", regular);
        return dataMap;
    }

    public static ImageEnum getRandom(Random random) {
        int pick = random.nextInt(ImageEnum.values().length);
        return ImageEnum.values()[pick];
    }

    public static ImageEnum getRandom(Random random, ImageEnum ... blacklisted) {
        List imageList = Arrays.stream(ImageEnum.values()).collect(Collectors.toList());
        for (ImageEnum image : blacklisted) {
            imageList.remove((Object)image);
        }
        int pick = random.nextInt(imageList.size());
        return (ImageEnum)((Object)imageList.get(pick));
    }
}

