/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.image;

import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.image.ImageEnum;
import com.mrbysco.captcha.client.screen.widget.ToggleButton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class ImageScreen
extends CaptchaScreen {
    private static final Random random = new Random();
    private ResourceLocation IMAGE = ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)"textures/gui/warp.png");
    private int SQUARE_SIZE = 64;
    private boolean[][] correctSquares = new boolean[4][4];
    private int tries = 0;
    private final ToggleButton[][] buttons = new ToggleButton[4][4];
    private Button button;
    protected MultiLineLabel error = MultiLineLabel.EMPTY;
    protected int errorY = 406;

    public ImageScreen(String code, int maxCompletionTime) {
        super((Component)Component.translatable((String)"captcha.image.screen"), code, maxCompletionTime);
    }

    protected void init() {
        super.init();
        this.message = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.empty(), Component.translatable((String)"captcha.image.screen"), Component.empty(), Component.translatable((String)"captcha.image.none")});
        this.updateImageSize();
        int startX = (this.width - this.SQUARE_SIZE * 4) / 2 - 4;
        int startY = (this.height - this.SQUARE_SIZE * 4) / 2 - 4;
        int n = this.message.getLineCount();
        Objects.requireNonNull(this.font);
        this.messageY = startY - n * 9 - 12;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                int id = row + col;
                int x = startX + col * this.SQUARE_SIZE + col * 4;
                int y = startY + row * this.SQUARE_SIZE + row * 4;
                int textureX = col * this.SQUARE_SIZE;
                int textureY = row * this.SQUARE_SIZE;
                ToggleButton toggleButton = new ToggleButton(x, y, this.SQUARE_SIZE, this.SQUARE_SIZE, textureX, textureY, this.IMAGE, 128, 128, button -> {
                    ((ToggleButton)button).setClicked(!((ToggleButton)button).isClicked());
                    this.updateButton();
                }, (Component)Component.literal((String)("square " + id)));
                this.buttons[row][col] = toggleButton;
                this.addRenderableWidget((GuiEventListener)toggleButton);
            }
        }
        this.changeImage(false);
        this.errorY = startY + this.SQUARE_SIZE * 4 + 16;
        this.button = Button.builder((Component)Component.translatable((String)"captcha.image.skip"), button -> this.checkSquares()).bounds(this.width / 2 - 60, startY + this.SQUARE_SIZE * 4 + 36, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button);
    }

    private void updateImageSize() {
        this.SQUARE_SIZE = 32;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.updateImageSize();
    }

    private void changeImage(boolean reset) {
        ImageEnum image = ImageEnum.getRandom(random);
        this.IMAGE = ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)("textures/gui/" + image.getImageName() + ".png"));
        List entries = image.getDataMap().entrySet().stream().toList();
        Map.Entry entry = (Map.Entry)entries.get(random.nextInt(entries.size()));
        String object = (String)entry.getKey();
        this.correctSquares = (boolean[][])entry.getValue();
        if (this.buttons.length > 0) {
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    ToggleButton toggleButton = this.buttons[x][y];
                    if (toggleButton == null) continue;
                    toggleButton.setResourceLocation(this.IMAGE);
                    toggleButton.setClicked(false);
                }
            }
        }
        if (reset) {
            this.error = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.text.failed").withStyle(ChatFormatting.RED), Component.translatable((String)"captcha.text.failed2").withStyle(ChatFormatting.RED)});
        }
        this.message = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.image.screen"), Component.empty(), Component.literal((String)object).withStyle(ChatFormatting.GOLD), Component.empty(), Component.translatable((String)"captcha.image.none")});
    }

    private void checkSquares() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                ToggleButton toggleButton = this.buttons[x][y];
                if (toggleButton == null || toggleButton.isClicked() == this.correctSquares[x][y]) continue;
                this.resetCaptcha();
                return;
            }
        }
        this.completeCaptcha();
    }

    private void updateButton() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                ToggleButton toggleButton = this.buttons[x][y];
                if (toggleButton == null || !toggleButton.isClicked()) continue;
                this.button.setMessage((Component)Component.translatable((String)"captcha.image.verify"));
                return;
            }
        }
        this.button.setMessage((Component)Component.translatable((String)"captcha.image.skip"));
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.changeImage(true);
            this.tries = 0;
            return;
        }
        if (this.tries > 1) {
            this.tries = 0;
            this.changeImage(true);
        } else {
            ++this.tries;
        }
    }

    @Override
    public int getMaxCompletionTime() {
        return super.getMaxCompletionTime();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.error.render(guiGraphics, MultiLineLabel.Align.CENTER, this.width / 2, this.errorY, 10, false, ARGB.opaque((int)0));
    }
}

