/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.math;

import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.math.MathOperation;
import com.mrbysco.captcha.client.screen.widget.NumberEditBox;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class MathScreen
extends CaptchaScreen {
    private static final Random random = new Random();
    private NumberEditBox answerBox;
    private MathOperation operation;
    private int valueX;
    private int valueY;
    private int answer;
    protected MultiLineLabel note = MultiLineLabel.EMPTY;

    public MathScreen(String code, int maxCompletionTime) {
        super((Component)Component.translatable((String)"captcha.math.screen"), code, maxCompletionTime);
        this.changeQuestion();
    }

    private void changeQuestion() {
        int tries;
        this.operation = MathOperation.getRandomOperation(random);
        double valueX = this.operation.generateX();
        double valueY = this.operation.generateY();
        double answer = this.operation.getAnswer(valueX, valueY);
        if (this.operation == MathOperation.DIVISION) {
            for (tries = 0; (valueX < valueY || valueX % valueY != 0.0) && tries < 20; ++tries) {
                valueX = 1.0 + this.operation.generateX();
                valueY = 1.0 + this.operation.generateY();
            }
            answer = valueX / valueY;
        }
        for (tries = 0; answer == 0.0 && tries < 5; ++tries) {
            valueX = this.operation.generateX();
            valueY = this.operation.generateY();
            answer = this.operation.getAnswer(valueX, valueY);
        }
        this.valueX = (int)valueX;
        this.valueY = (int)valueY;
        this.answer = (int)answer;
        if (this.answer == 0 || (double)this.answer != this.operation.getAnswer(this.valueX, this.valueY)) {
            this.operation = MathOperation.ADDITION;
            this.valueX = 9;
            this.valueY = 10;
            this.answer = 19;
        }
    }

    protected void init() {
        super.init();
        this.message = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.math.screen"), Component.translatable((String)"captcha.math.screen2"), Component.empty(), Component.translatable((String)"captcha.math.question", (Object[])new Object[]{this.valueX, this.operation.getSymbol(), this.valueY}).withStyle(ChatFormatting.YELLOW)});
        int i = (this.message.getLineCount() + 1) * 9;
        this.answerBox = new NumberEditBox(this.font, 76 + i, 140, 60, 20, (Component)Component.empty());
        this.answerBox.setMaxLength(8);
        this.answerBox.setX(this.width / 2 - this.answerBox.getWidth() / 2);
        this.addWidget((GuiEventListener)this.answerBox);
        this.note = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.math.note").withStyle(ChatFormatting.RED)});
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.resetCaptcha();
        }
    }

    public void checkAnswer() {
        if (this.answerBox.getInt() == (float)this.answer) {
            this.completeCaptcha();
        } else {
            this.resetCaptcha();
        }
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
        this.answerBox.setValue("");
        this.changeQuestion();
        this.message = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.math.screen"), Component.translatable((String)"captcha.math.screen2"), Component.empty(), Component.translatable((String)"captcha.math.question", (Object[])new Object[]{this.valueX, this.operation.getSymbol(), this.valueY}).withStyle(ChatFormatting.YELLOW)});
    }

    public boolean keyPressed(KeyEvent event) {
        if (super.keyPressed(event)) {
            return true;
        }
        if (event.key() == 257 || event.key() == 335) {
            this.checkAnswer();
            return true;
        }
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.answerBox != null) {
            this.answerBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.note.render(guiGraphics, MultiLineLabel.Align.CENTER, this.width / 2, 120, 10, false, ARGB.opaque((int)0));
    }
}

