/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.slide;

import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.image.ImageEnum;
import com.mrbysco.captcha.client.screen.slide.PuzzleSlider;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SlideScreen
extends CaptchaScreen {
    private static final Random random = new Random();
    private ResourceLocation IMAGE = ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)"textures/gui/amethyst.png");
    protected int puzzleY;
    protected int puzzleX = 16;
    protected double acceptedMin;
    protected double acceptedMax;
    protected PuzzleSlider slider;
    protected int attemptCount = 0;

    public SlideScreen(String code, int maxCompletionTime) {
        super((Component)Component.translatable((String)"captcha.slide.screen"), code, maxCompletionTime);
        this.resetPuzzle();
    }

    private void resetPuzzle() {
        ImageEnum image = ImageEnum.getRandom(random, ImageEnum.SANDY, ImageEnum.VEHICLE);
        this.IMAGE = ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)("textures/gui/" + image.getImageName() + ".png"));
        OptionalInt randomNumber = random.ints(32, 85).findFirst();
        this.puzzleX = randomNumber.isPresent() ? randomNumber.getAsInt() : 32;
        this.acceptedMin = (double)this.puzzleX - 0.1 - 16.0;
        this.acceptedMax = (double)this.puzzleX + 0.4 - 16.0;
        randomNumber = random.ints(32, 85).findFirst();
        int n = this.puzzleY = randomNumber.isPresent() ? randomNumber.getAsInt() : 32;
        if (this.slider != null) {
            this.slider.setValue(0.0);
        }
    }

    protected void init() {
        super.init();
        this.slider = new PuzzleSlider(this.width / 2 - 100, this.height / 2 + 100, 200, 20, (Component)Component.empty(), (Component)Component.empty(), 0.0, 84.0, 0.0, 0.1, 0, slider -> {
            double sliderValue = slider.getValue();
            if (sliderValue >= this.acceptedMin && sliderValue <= this.acceptedMax) {
                this.completeCaptcha();
            }
            ++this.attemptCount;
            if (this.attemptCount >= 20) {
                this.completeCaptcha();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.slider);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.resetCaptcha();
        }
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.resetPuzzle();
        }
    }

    @Override
    public int getMaxCompletionTime() {
        return super.getMaxCompletionTime();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int pieceX = this.width / 2 - 100 + this.puzzleX * 2 - 32;
        int pieceY = this.height / 2 - 100 + this.puzzleY * 2 - 32;
        guiGraphics.fillGradient(pieceX, pieceY, pieceX + 32, pieceY + 32, -1509949440, -1509949440);
        int sliderX = this.width / 2 - 100 + (int)(this.slider.getValue() * 2.0);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.IMAGE, sliderX, pieceY, (float)(this.puzzleX * 2 - 32), (float)(this.puzzleY * 2 - 32), 32, 32, 200, 200);
        guiGraphics.fillGradient(sliderX, pieceY, sliderX + 32, pieceY + 32, 0x1AFFFFFF, 0x1AFFFFFF);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.IMAGE, this.width / 2 - 100, this.height / 2 - 100, 0.0f, 0.0f, 200, 200, 200, 200);
    }
}

