/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.text;

import com.mojang.blaze3d.platform.NativeImage;
import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.text.RenderUtil;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class TextScreen
extends CaptchaScreen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)"text");
    private static final Random random = new Random();
    private EditBox answerBox;
    private String currentWord;
    private DynamicTexture scrambledImage;
    protected MultiLineLabel note = MultiLineLabel.EMPTY;
    private final List<? extends String> configuredWords;

    public TextScreen(String code, int maxCompletionTime, List<? extends String> configuredWords) {
        super((Component)Component.translatable((String)"captcha.text.screen"), code, maxCompletionTime);
        this.configuredWords = configuredWords;
        this.changeText();
        this.messageY = 170;
    }

    private String randomWord() {
        return this.configuredWords.get(random.nextInt(this.configuredWords.size()));
    }

    private void changeText() {
        this.currentWord = this.randomWord();
        try {
            this.scrambledImage = RenderUtil.generateCaptchaTexture(this.currentWord, 200, 40);
            if (this.scrambledImage != null) {
                Minecraft mc = Minecraft.getInstance();
                mc.getTextureManager().register(ResourceLocation.fromNamespaceAndPath((String)"captcha", (String)"text"), (AbstractTexture)this.scrambledImage);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void init() {
        super.init();
        this.message = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.text.screen")});
        this.answerBox = new EditBox(this.font, 76, 190, 120, 20, (Component)Component.empty());
        this.answerBox.setMaxLength(16);
        this.answerBox.setX(this.width / 2 - this.answerBox.getWidth() / 2);
        this.addWidget((GuiEventListener)this.answerBox);
        this.note = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Component.translatable((String)"captcha.text.note").withStyle(ChatFormatting.RED)});
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.resetCaptcha();
        }
    }

    public void checkAnswer() {
        if (this.answerBox.getValue().equals(this.currentWord)) {
            this.completeCaptcha();
        } else {
            this.resetCaptcha();
        }
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
        this.answerBox.setValue("");
        this.changeText();
    }

    public boolean keyPressed(KeyEvent event) {
        if (super.keyPressed(event)) {
            return true;
        }
        if (event.key() == 257 || event.key() == 335) {
            this.checkAnswer();
            return true;
        }
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.answerBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.note.render(guiGraphics, MultiLineLabel.Align.CENTER, this.width / 2, 220, 10, false, ARGB.opaque((int)0));
        if (this.scrambledImage != null) {
            NativeImage nativeImage = this.scrambledImage.getPixels();
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.width / 2 - nativeImage.getWidth() / 2, 80 + nativeImage.getHeight(), 0.0f, 0.0f, nativeImage.getWidth(), nativeImage.getHeight(), nativeImage.getWidth(), nativeImage.getHeight());
        }
    }
}

