/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.widget;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberEditBox
extends EditBox {
    public NumberEditBox(Font font, int x, int y, int width, int height, Component defaultValue) {
        super(font, x, y, width, height, defaultValue);
    }

    public void insertText(String textToWrite) {
        if (this.isNumeric(textToWrite)) {
            super.insertText(textToWrite);
        }
    }

    public String getValue() {
        return this.isNumeric(super.getValue()) ? super.getValue() : "0";
    }

    public float getInt() {
        return NumberUtils.toInt((String)super.getValue(), (int)0);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.setHighlightPos(this.getValue().length());
            this.moveCursorToEnd(false);
        }
    }

    private boolean isNumeric(String value) {
        return value.equals("-") || NumberUtils.isParsable((String)value);
    }
}

