/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.captcha.client.CaptchaEnum;
import com.mrbysco.captcha.platform.Services;
import com.mrbysco.captcha.util.CaptchaManager;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class CaptchaCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"captcha");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"forceCaptcha").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"captchaName", (ArgumentType)StringArgumentType.word()).suggests((cs, builder) -> {
            ArrayList<String> captchaNames = new ArrayList<String>();
            for (CaptchaEnum eCaptcha : CaptchaEnum.values()) {
                captchaNames.add(eCaptcha.getCaptchaName());
            }
            return SharedSuggestionProvider.suggest(captchaNames, (SuggestionsBuilder)builder);
        }).executes(CaptchaCommands::forceCaptcha))));
        dispatcher.register(root);
    }

    private static int forceCaptcha(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String captchaName = StringArgumentType.getString(ctx, (String)"captchaName");
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            UUID uuid = player.getUUID();
            CaptchaManager.forgetUser(uuid);
            String code = CaptchaManager.applyRandomCode(uuid);
            Services.PLATFORM.sendRequireCaptchaMessage(player, captchaName, code);
        }
        return 0;
    }
}

