/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CaptchaConfigNeoForge {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue gracePeriod;
        public final ModConfigSpec.IntValue captchaTime;
        public final ModConfigSpec.IntValue captchaCooldown;
        public final ModConfigSpec.IntValue additionMaxX;
        public final ModConfigSpec.IntValue additionMaxY;
        public final ModConfigSpec.IntValue subtractionMaxX;
        public final ModConfigSpec.IntValue subtractionMaxY;
        public final ModConfigSpec.IntValue multiplicationMaxX;
        public final ModConfigSpec.IntValue multiplicationMaxY;
        public final ModConfigSpec.IntValue divisionMaxX;
        public final ModConfigSpec.IntValue divisionMaxY;
        public final ModConfigSpec.ConfigValue<List<? extends String>> textCaptchaWords;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.gracePeriod = builder.comment("").defineInRange("gracePeriod", 6000, 0, Integer.MAX_VALUE);
            this.captchaTime = builder.comment("Defines the amount of time in seconds in which the captcha should be solved [Default: 15]").defineInRange("captchaTime", 15, 1, Integer.MAX_VALUE);
            this.captchaCooldown = builder.comment("Defines the cooldown between captcha requests in seconds [Default: 900 (15 minutes)]").defineInRange("captchaCooldown", 900, 30, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Math settings").push("Math");
            this.additionMaxX = builder.comment("Defines the max the first number can be in the addition problem [Default: 100]").defineInRange("additionMaxX", 100, 1, Integer.MAX_VALUE);
            this.additionMaxY = builder.comment("Defines the max the second number can be in the addition problem [Default: 100]").defineInRange("additionMaxY", 100, 30, Integer.MAX_VALUE);
            this.subtractionMaxX = builder.comment("Defines the max the first number can be in the subtraction problem [Default: 100]").defineInRange("subtractionMaxX", 100, 1, Integer.MAX_VALUE);
            this.subtractionMaxY = builder.comment("Defines the max the second number can be in the subtraction problem [Default: 100]").defineInRange("subtractionMaxY", 100, 30, Integer.MAX_VALUE);
            this.multiplicationMaxX = builder.comment("Defines the max the first number can be in the multiplication problem [Default: 20]").defineInRange("multiplicationMaxX", 20, 1, Integer.MAX_VALUE);
            this.multiplicationMaxY = builder.comment("Defines the max the second number can be in the multiplication problem [Default: 20]").defineInRange("multiplicationMaxY", 20, 20, Integer.MAX_VALUE);
            this.divisionMaxX = builder.comment("Defines the max the first number can be in the division problem [Default: 100]").defineInRange("divisionMaxX", 100, 1, Integer.MAX_VALUE);
            this.divisionMaxY = builder.comment("Defines the max the second number can be in the division problem [Default: 100]").defineInRange("divisionMaxY", 100, 30, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Text settings").push("Text");
            this.textCaptchaWords = builder.comment("List of words that can be used to generate a text captcha (16 character length max)").defineList("textCaptchaWords", List.of("diamond", "iron", "gold", "emerald", "lapis", "coal", "redstone", "nether", "creeper", "skeleton", "spider", "zombie", "enderman", "endermite", "slime", "ghast", "pig", "cow", "sheep", "chicken", "rabbit", "mooshroom", "villager", "witch", "wither", "blaze", "guardian", "shulker", "ender dragon", "wither", "drowned", "husk", "stray", "phantom", "zoglin", "piglin", "panda", "bee", "cat", "fox", "ocelot"), String::new, s -> s instanceof String && !((String)s).isEmpty() && ((String)s).length() <= 16);
            builder.pop();
        }
    }
}

