/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.commands.subcommands;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.zetaplugins.wyg.services.ItemDisplayService;
import com.zetaplugins.wyg.shaded.commandapi.CommandAPICommand;
import com.zetaplugins.wyg.shaded.commandapi.arguments.Argument;
import com.zetaplugins.wyg.shaded.commandapi.arguments.PlayerProfileArgument;
import com.zetaplugins.wyg.shaded.commandapi.arguments.SafeSuggestions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class BaseEquipmentCommand {
    private final String commandName;
    private final String slotDisplayName;

    protected BaseEquipmentCommand(String commandName, String slotDisplayName) {
        this.commandName = commandName;
        this.slotDisplayName = slotDisplayName;
    }

    public CommandAPICommand getCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(this.commandName).withOptionalArguments(new Argument[]{(Argument)new PlayerProfileArgument("target").replaceSafeSuggestions(SafeSuggestions.suggest(info -> {
            Player sender = (Player)info.sender();
            return (PlayerProfile[])Bukkit.getOnlinePlayers().stream().filter(player -> !player.equals((Object)sender)).map(Player::getPlayerProfile).toArray(PlayerProfile[]::new);
        }))})).executesPlayer((sender, args) -> {
            Player target = args.getOptional("target").orElse(null);
            if (!ItemDisplayService.validateTarget(sender, target)) {
                return;
            }
            ItemStack item = this.getItemFromPlayer(sender);
            ItemDisplayService.showItem(sender, target, item, this.slotDisplayName);
        });
    }

    protected abstract ItemStack getItemFromPlayer(Player var1);
}

