/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.config;

import com.zetaplugins.wyg.WYG;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final WYG plugin;
    private FileConfiguration config;

    public ConfigManager(WYG plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getItemDisplayFormat() {
        return this.config.getString("item-display.format", "[<sprite> <item>]");
    }

    public String getShareMessageFormat() {
        return this.config.getString("share-message.format", "<player> <gray>shared</gray> <item>");
    }

    public boolean isHoverTextEnabled() {
        return this.config.getBoolean("hover-text.enabled", true);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public List<String> getTooltipLayout() {
        return this.config.getStringList("hover-text.layout");
    }

    public String getEnchantmentFormat() {
        return this.config.getString("hover-text.enchantment-format", "<gray><enchantment> <level></gray>");
    }

    public String getStackFormat() {
        return this.config.getString("hover-text.stack-format", "<gray>Stack Size: <amount></gray>");
    }

    public String getAttributeSlotHeaderFormat() {
        return this.config.getString("hover-text.attributes.slot-header-format", "<gray>When <slot>:</gray>");
    }

    public String getAttributeFormat(String attributeType) {
        return this.config.getString("hover-text.attributes.formats." + attributeType, "<value> " + attributeType.replace("_", " "));
    }

    public String getDurabilityFormat() {
        return this.config.getString("hover-text.durability-format", "<gray>Durability: <current>/<max></gray>");
    }

    public String getItemNameFormat() {
        return this.config.getString("hover-text.item-name.format", "<item_name>");
    }

    public boolean isRenderItemNameWhenSame() {
        return this.config.getBoolean("hover-text.item-name.render-if-same-as-name", false);
    }
}

