/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.services;

import com.zetaplugins.wyg.services.EquipmentSlotParser;
import com.zetaplugins.wyg.utils.ItemDisplayBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChatItemReplacer {
    private static final Pattern SLOT_PATTERN = Pattern.compile("\\[([a-zA-Z]+)\\]");

    public static Component processMessage(Player player, Component originalMessage) {
        String messageText = PlainTextComponentSerializer.plainText().serialize(originalMessage);
        Matcher matcher = SLOT_PATTERN.matcher(messageText);
        if (!matcher.find()) {
            return null;
        }
        matcher.reset();
        TextComponent.Builder messageBuilder = Component.text();
        int lastEnd = 0;
        boolean hasReplacements = false;
        while (matcher.find()) {
            Component itemComponent;
            String slotName = matcher.group(1);
            if (matcher.start() > lastEnd) {
                String beforeMatch = messageText.substring(lastEnd, matcher.start());
                messageBuilder.append(Component.text((String)beforeMatch).style(originalMessage.style()));
            }
            if ((itemComponent = ChatItemReplacer.createItemComponent(player, slotName)) != null) {
                messageBuilder.append(itemComponent);
                hasReplacements = true;
            } else {
                messageBuilder.append(Component.text((String)matcher.group()).style(originalMessage.style()));
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < messageText.length()) {
            String afterMatch = messageText.substring(lastEnd);
            messageBuilder.append(Component.text((String)afterMatch).style(originalMessage.style()));
        }
        return hasReplacements ? messageBuilder.build() : null;
    }

    private static Component createItemComponent(Player player, String slotName) {
        if (!EquipmentSlotParser.isValidSlot(slotName)) {
            return null;
        }
        ItemStack item = EquipmentSlotParser.getItemFromSlot(player, slotName);
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        return ItemDisplayBuilder.buildItemComponent(player, item);
    }
}

