/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.services;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EquipmentSlotParser {
    private static final Map<String, Function<Player, ItemStack>> SLOT_GETTERS = new HashMap<String, Function<Player, ItemStack>>();

    public static ItemStack getItemFromSlot(Player player, String slotName) {
        Function<Player, ItemStack> getter = SLOT_GETTERS.get(slotName.toLowerCase());
        return getter != null ? getter.apply(player) : null;
    }

    public static boolean isValidSlot(String slotName) {
        return SLOT_GETTERS.containsKey(slotName.toLowerCase());
    }

    static {
        SLOT_GETTERS.put("hand", player -> player.getInventory().getItemInMainHand());
        SLOT_GETTERS.put("mainhand", player -> player.getInventory().getItemInMainHand());
        SLOT_GETTERS.put("offhand", player -> player.getInventory().getItemInOffHand());
        SLOT_GETTERS.put("helmet", player -> player.getInventory().getHelmet());
        SLOT_GETTERS.put("head", player -> player.getInventory().getHelmet());
        SLOT_GETTERS.put("chestplate", player -> player.getInventory().getChestplate());
        SLOT_GETTERS.put("chest", player -> player.getInventory().getChestplate());
        SLOT_GETTERS.put("leggings", player -> player.getInventory().getLeggings());
        SLOT_GETTERS.put("legs", player -> player.getInventory().getLeggings());
        SLOT_GETTERS.put("boots", player -> player.getInventory().getBoots());
        SLOT_GETTERS.put("feet", player -> player.getInventory().getBoots());
    }
}

