/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.shaded.commandapi;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.zetaplugins.wyg.shaded.commandapi.StringTooltip;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class Tooltip<S> {
    private final S object;
    private final Message tooltipMessage;

    protected Tooltip(S object, Message tooltip) {
        this.object = object;
        this.tooltipMessage = tooltip;
    }

    public S getSuggestion() {
        return this.object;
    }

    public Message getTooltip() {
        return this.tooltipMessage;
    }

    public static <S> Tooltip<S> ofString(S object, String tooltip) {
        return Tooltip.ofMessage(object, Tooltip.messageFromString(tooltip));
    }

    public static <S> Tooltip<S> ofMessage(S object, Message tooltip) {
        return new Tooltip<S>(object, tooltip);
    }

    public static <S> Tooltip<S> none(S object) {
        return new Tooltip<S>(object, null);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> none(S ... suggestions) {
        return Tooltip.generate(Object::toString, (S s, T t) -> Tooltip.none(s), suggestions);
    }

    public static <S> Collection<Tooltip<S>> none(Collection<S> suggestions) {
        return Tooltip.generate(Object::toString, (S s, T t) -> Tooltip.none(s), suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateStrings(Function<S, String> tooltipGenerator, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofString, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateStrings(Function<S, String> tooltipGenerator, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofString, suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateMessages(Function<S, Message> tooltipGenerator, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofMessage, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateMessages(Function<S, Message> tooltipGenerator, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofMessage, suggestions);
    }

    @SafeVarargs
    protected static <S, T> Collection<Tooltip<S>> generate(Function<S, T> tooltipGenerator, BiFunction<S, T, Tooltip<S>> tooltipWrapper, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, tooltipWrapper, Arrays.stream(suggestions));
    }

    protected static <S, T> Collection<Tooltip<S>> generate(Function<S, T> tooltipGenerator, BiFunction<S, T, Tooltip<S>> tooltipWrapper, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, tooltipWrapper, suggestions.stream());
    }

    private static <S, T> Collection<Tooltip<S>> generate(Function<S, T> tooltipGenerator, BiFunction<S, T, Tooltip<S>> tooltipWrapper, Stream<S> suggestions) {
        return suggestions.map(suggestion -> (Tooltip)tooltipWrapper.apply(suggestion, tooltipGenerator.apply(suggestion))).toList();
    }

    @SafeVarargs
    public static <S> Tooltip<S>[] arrayOf(Tooltip<S> ... tooltips) {
        return tooltips;
    }

    public static <S> Function<Tooltip<S>, StringTooltip> build(Function<S, String> mapper) {
        return t -> StringTooltip.ofMessage((String)mapper.apply(t.object), t.tooltipMessage);
    }

    public static Message messageFromString(String string) {
        return new LiteralMessage(string);
    }
}

