/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.shaded.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.zetaplugins.wyg.shaded.commandapi.CommandAPIBukkit;
import com.zetaplugins.wyg.shaded.commandapi.arguments.CommandAPIArgumentType;
import com.zetaplugins.wyg.shaded.commandapi.arguments.LocationType;
import com.zetaplugins.wyg.shaded.commandapi.arguments.SafeOverrideableArgument;
import com.zetaplugins.wyg.shaded.commandapi.executors.CommandArguments;
import com.zetaplugins.wyg.shaded.commandapi.wrappers.Location2D;

public class Location2DArgument
extends SafeOverrideableArgument<Location2D, Location2D> {
    private final boolean isPrecise;

    public Location2DArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public Location2DArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public Location2DArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get().getNMS()._ArgumentPosition2D() : CommandAPIBukkit.get().getNMS()._ArgumentVec2(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location2D> getPrimitiveType() {
        return Location2D.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION_2D;
    }

    @Override
    public <CommandSourceStack> Location2D parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getNMS().getLocation2DPrecise(cmdCtx, key) : CommandAPIBukkit.get().getNMS().getLocation2DBlock(cmdCtx, key);
    }
}

