/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.utils;

import com.zetaplugins.wyg.WYG;
import com.zetaplugins.wyg.utils.SpriteResolver;
import com.zetaplugins.wyg.utils.TooltipBuilder;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemDisplayBuilder {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();

    public static Component createItemShareMessage(Player player, ItemStack item) {
        Component itemComponent = ItemDisplayBuilder.buildItemComponent(player, item);
        String format = WYG.getInstance().getConfigManager().getShareMessageFormat();
        TagResolver.Single playerResolver = Placeholder.component((String)"player", (ComponentLike)Component.text((String)player.getName()));
        TagResolver.Single itemResolver = Placeholder.component((String)"item", (ComponentLike)itemComponent);
        TagResolver combinedResolver = TagResolver.resolver((TagResolver[])new TagResolver[]{playerResolver, itemResolver, SpriteResolver.full(player, item)});
        return MINI_MESSAGE.deserialize(format, combinedResolver);
    }

    public static Component buildItemComponent(Player player, ItemStack item) {
        List<Component> tooltipLines;
        Component formattedComponent;
        Component itemName = item.effectiveName();
        Material material = item.getType();
        String format = WYG.getInstance().getConfigManager().getItemDisplayFormat();
        if (material.isBlock()) {
            String blockFormat = format.replace("<sprite> ", "").replace(" <sprite>", "").replace("<sprite>", "");
            TagResolver.Single itemResolver = Placeholder.component((String)"item", (ComponentLike)itemName);
            TagResolver spriteResolvers = SpriteResolver.forTooltips(item);
            formattedComponent = MINI_MESSAGE.deserialize(blockFormat, TagResolver.resolver((TagResolver[])new TagResolver[]{itemResolver, spriteResolvers}));
        } else {
            Component spriteComponent = SpriteResolver.createItemSprite(material);
            TagResolver.Single spriteResolver = Placeholder.component((String)"sprite", (ComponentLike)spriteComponent);
            TagResolver.Single itemResolver = Placeholder.component((String)"item", (ComponentLike)itemName);
            TagResolver customSpriteResolvers = SpriteResolver.forTooltips(item);
            formattedComponent = MINI_MESSAGE.deserialize(format, TagResolver.resolver((TagResolver[])new TagResolver[]{spriteResolver, itemResolver, customSpriteResolvers}));
        }
        if (WYG.getInstance().getConfigManager().isHoverTextEnabled() && !(tooltipLines = TooltipBuilder.buildTooltip(item, player)).isEmpty()) {
            Component hoverComponent = TooltipBuilder.createHoverComponent(tooltipLines);
            formattedComponent = formattedComponent.hoverEvent((HoverEventSource)hoverComponent);
        }
        return formattedComponent;
    }
}

