/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.utils;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.object.ObjectContents;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpriteResolver {
    public static Component createItemSprite(Material material) {
        String itemKey = material.getKey().getKey();
        String spritePath = "item/" + itemKey;
        return Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)spritePath)));
    }

    public static Component createCustomSprite(String path) {
        path = path.replaceAll("^/+|/+$", "");
        return Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)path)));
    }

    public static Component createCustomSprite(String atlas, String path) {
        path = path.replaceAll("^/+|/+$", "");
        return Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)"minecraft", (String)atlas), (Key)Key.key((String)path)));
    }

    public static Component createNamespacedSprite(String namespace, String path) {
        path = path.replaceAll("^/+|/+$", "");
        return Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)namespace, (String)path)));
    }

    public static Component createPlayerHeadSprite(Player player) {
        return Component.object((ObjectContents)ObjectContents.playerHead((String)player.getName()));
    }

    public static Component createPlayerHeadSprite(String playerName) {
        return Component.object((ObjectContents)ObjectContents.playerHead((String)playerName));
    }

    public static TagResolver spriteResolver() {
        return TagResolver.resolver((String)"sprite", (args, ctx) -> {
            Component spriteComponent;
            String argument = args.popOr("Missing sprite path").value();
            if (argument.contains(":")) {
                String[] parts = argument.split(":", 2);
                String firstPart = parts[0];
                String secondPart = parts[1];
                if (secondPart.contains(":")) {
                    String[] subParts = secondPart.split(":", 2);
                    spriteComponent = SpriteResolver.createNamespacedSprite(firstPart, subParts[1]);
                } else if (secondPart.contains("/")) {
                    String[] pathParts = secondPart.split("/", 2);
                    String possibleAtlas = pathParts[0];
                    if (SpriteResolver.isKnownAtlas(possibleAtlas)) {
                        String atlas = possibleAtlas;
                        String path = pathParts[1];
                        spriteComponent = Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)firstPart, (String)atlas), (Key)Key.key((String)path)));
                    } else {
                        spriteComponent = SpriteResolver.createNamespacedSprite(firstPart, secondPart);
                    }
                } else {
                    spriteComponent = SpriteResolver.createNamespacedSprite(firstPart, secondPart);
                }
            } else if (argument.contains("/")) {
                String[] pathParts = argument.split("/", 2);
                String possibleAtlas = pathParts[0];
                if (SpriteResolver.isKnownAtlas(possibleAtlas)) {
                    String atlas = possibleAtlas;
                    String path = pathParts[1];
                    spriteComponent = SpriteResolver.createCustomSprite(atlas, path);
                } else {
                    spriteComponent = SpriteResolver.createCustomSprite(argument);
                }
            } else {
                spriteComponent = SpriteResolver.createCustomSprite(argument);
            }
            return Tag.selfClosingInserting((Component)spriteComponent);
        });
    }

    private static boolean isKnownAtlas(String name) {
        return switch (name) {
            case "gui", "blocks", "items", "particles", "mob_effects", "paintings", "map_decorations" -> true;
            default -> false;
        };
    }

    public static TagResolver itemSpriteResolver(ItemStack item) {
        return TagResolver.resolver((String)"item_sprite", (args, ctx) -> {
            Component spriteComponent = SpriteResolver.createItemSprite(item.getType());
            return Tag.selfClosingInserting((Component)spriteComponent);
        });
    }

    public static TagResolver playerHeadResolver(Player player) {
        return TagResolver.resolver((String)"player_head", (args, ctx) -> {
            Component headComponent = SpriteResolver.createPlayerHeadSprite(player);
            return Tag.selfClosingInserting((Component)headComponent);
        });
    }

    public static TagResolver playerHeadWithArgResolver() {
        return TagResolver.resolver((String)"player_head", (args, ctx) -> {
            String playerName = args.popOr("Missing player name").value();
            Component headComponent = SpriteResolver.createPlayerHeadSprite(playerName);
            return Tag.selfClosingInserting((Component)headComponent);
        });
    }

    public static TagResolver basic() {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{SpriteResolver.spriteResolver(), SpriteResolver.playerHeadWithArgResolver()});
    }

    public static TagResolver forTooltips(ItemStack item) {
        return TagResolver.builder().resolver(SpriteResolver.spriteResolver()).resolver(SpriteResolver.itemSpriteResolver(item)).resolver(SpriteResolver.playerHeadWithArgResolver()).build();
    }

    public static TagResolver forPlayer(Player player) {
        return TagResolver.builder().resolver(SpriteResolver.spriteResolver()).resolver(SpriteResolver.playerHeadResolver(player)).resolver(SpriteResolver.playerHeadWithArgResolver()).build();
    }

    public static TagResolver full(Player player, ItemStack item) {
        return TagResolver.builder().resolver(SpriteResolver.spriteResolver()).resolver(SpriteResolver.itemSpriteResolver(item)).resolver(SpriteResolver.playerHeadResolver(player)).resolver(SpriteResolver.playerHeadWithArgResolver()).build();
    }
}

