/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.wyg.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.zetaplugins.wyg.WYG;
import com.zetaplugins.wyg.utils.SpriteResolver;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class TooltipBuilder {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    public static List<Component> buildTooltip(ItemStack item) {
        return TooltipBuilder.buildTooltip(item, null);
    }

    public static List<Component> buildTooltip(ItemStack item, Player sender) {
        if (!WYG.getInstance().getConfigManager().isHoverTextEnabled()) {
            return List.of();
        }
        ItemMeta meta = item.getItemMeta();
        Multimap<Attribute, AttributeModifier> allAttributes = TooltipBuilder.getItemAttributes(item, meta);
        List<String> layout = WYG.getInstance().getConfigManager().getTooltipLayout();
        ArrayList<Component> lines = new ArrayList<Component>();
        boolean lastWasBlank = false;
        for (String layoutLine : layout) {
            if (layoutLine.isEmpty() || layoutLine.isBlank()) {
                if (lines.isEmpty()) continue;
                lastWasBlank = true;
                continue;
            }
            List<Component> expanded = TooltipBuilder.expandLine(layoutLine, item, meta, allAttributes, sender);
            if (!expanded.isEmpty() && lastWasBlank) {
                lines.add((Component)Component.empty());
                lastWasBlank = false;
            }
            lines.addAll(expanded);
        }
        return lines;
    }

    private static Multimap<Attribute, AttributeModifier> getItemAttributes(ItemStack item, ItemMeta meta) {
        if (meta != null && meta.hasAttributeModifiers()) {
            return meta.getAttributeModifiers();
        }
        return item.getType().getDefaultAttributeModifiers();
    }

    private static List<Component> expandLine(String line, ItemStack item, ItemMeta meta, Multimap<Attribute, AttributeModifier> allAttributes, Player sender) {
        if (line.trim().equals("<enchantments>")) {
            return TooltipBuilder.getEnchantmentLines(item, meta);
        }
        if (line.trim().equals("<lore>")) {
            return TooltipBuilder.getLoreLines(meta);
        }
        if (line.trim().equals("<attributes>")) {
            return TooltipBuilder.getAllAttributeLines(allAttributes, sender);
        }
        if (line.trim().matches("<attributes:(attack_damage|attack_speed|armor|armor_toughness|knockback_resistance)>")) {
            String attributeType = line.trim().replaceAll("<attributes:|>", "");
            return TooltipBuilder.getAttributeTypeLines(allAttributes, attributeType, false, sender);
        }
        if (line.trim().matches("<attributes_header:(hand|off_hand|head|chest|legs|feet)>")) {
            String slotName = line.trim().replaceAll("<attributes_header:|>", "");
            EquipmentSlot slot = TooltipBuilder.parseEquipmentSlot(slotName);
            if (slot != null) {
                ArrayList<Component> header = new ArrayList<Component>();
                TooltipBuilder.addSlotHeader(slot, header);
                return header;
            }
            return List.of();
        }
        if (line.trim().equals("<durability>")) {
            Component comp = TooltipBuilder.buildDurabilityComponent(item, meta);
            return comp == null ? List.of() : List.of(comp);
        }
        Component rendered = TooltipBuilder.renderSingleLine(line, item, meta, allAttributes, sender);
        return rendered != null ? List.of(rendered) : List.of();
    }

    private static Component renderSingleLine(String line, ItemStack item, ItemMeta meta, Multimap<Attribute, AttributeModifier> allAttributes, Player sender) {
        TagResolver.Builder resolvers = TagResolver.builder();
        if (line.contains("<item_name>")) {
            boolean renderWhenSame = WYG.getInstance().getConfigManager().isRenderItemNameWhenSame();
            TranslatableComponent baseItemName = Component.translatable((String)item.getType().translationKey());
            String display = PlainTextComponentSerializer.plainText().serialize(item.effectiveName());
            String base = PlainTextComponentSerializer.plainText().serialize((Component)baseItemName);
            boolean sameText = display.equals(base);
            if (!renderWhenSame && sameText) {
                return null;
            }
        }
        if (line.contains("<name>")) {
            resolvers.resolver((TagResolver)Placeholder.component((String)"name", (ComponentLike)item.effectiveName()));
        }
        if (line.contains("<item_name>")) {
            TranslatableComponent formattedItemName;
            TranslatableComponent materialName = Component.translatable((String)item.getType().translationKey());
            String format = WYG.getInstance().getConfigManager().getItemNameFormat();
            try {
                formattedItemName = MINI_MESSAGE.deserialize(format, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"item_name", (ComponentLike)materialName), SpriteResolver.forTooltips(item)}));
            }
            catch (Exception e) {
                WYG.getInstance().getLogger().warning("Failed to parse item_name format: " + format + " - " + e.getMessage());
                formattedItemName = materialName;
            }
            resolvers.resolver((TagResolver)Placeholder.component((String)"item_name", (ComponentLike)formattedItemName));
        }
        if (line.contains("<stack>")) {
            if (item.getAmount() <= 1) {
                return null;
            }
            String stackFormat = WYG.getInstance().getConfigManager().getStackFormat();
            Component stackComponent = MINI_MESSAGE.deserialize(stackFormat, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"amount", (String)String.valueOf(item.getAmount())), SpriteResolver.forTooltips(item)}));
            resolvers.resolver((TagResolver)Placeholder.component((String)"stack", (ComponentLike)stackComponent));
        }
        if (line.contains("<durability_current>")) {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                int currentDurability = item.getType().getMaxDurability() - damageable.getDamage();
                resolvers.resolver((TagResolver)Placeholder.parsed((String)"durability_current", (String)String.valueOf(currentDurability)));
            } else {
                return null;
            }
        }
        if (line.contains("<durability_max>")) {
            if (item.getType().getMaxDurability() > 0) {
                resolvers.resolver((TagResolver)Placeholder.parsed((String)"durability_max", (String)String.valueOf(item.getType().getMaxDurability())));
            } else {
                return null;
            }
        }
        if (line.contains("<attributes:")) {
            resolvers.resolver(TagResolver.resolver((String)"attributes", (args, ctx) -> {
                String attributeType = args.popOr("Missing attribute type").value();
                Attribute attribute = TooltipBuilder.parseAttributeType(attributeType);
                if (attribute == null) {
                    return Tag.selfClosingInserting((Component)Component.empty());
                }
                List<Component> components = TooltipBuilder.getAttributeTypeLines(allAttributes, attributeType, false, sender);
                TextComponent component = components.isEmpty() ? Component.empty() : components.get(0);
                return Tag.selfClosingInserting((Component)component);
            }));
        }
        if (line.contains("<durability>")) {
            resolvers.resolver(TagResolver.resolver((String)"durability", (args, ctx) -> {
                Component comp = TooltipBuilder.buildDurabilityComponent(item, meta);
                return Tag.selfClosingInserting((Component)(comp == null ? Component.empty() : comp));
            }));
        }
        try {
            Component out = MINI_MESSAGE.deserialize(line, TagResolver.resolver((TagResolver[])new TagResolver[]{resolvers.build(), SpriteResolver.forTooltips(item)}));
            if (TooltipBuilder.isEffectivelyBlank(out)) {
                return null;
            }
            return out;
        }
        catch (Exception e) {
            WYG.getInstance().getLogger().warning("Failed to parse tooltip line: " + line + " - " + e.getMessage());
            return Component.text((String)line);
        }
    }

    private static Component buildDurabilityComponent(ItemStack item, ItemMeta meta) {
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            short max = item.getType().getMaxDurability();
            if (max <= 0) {
                return null;
            }
            int current = Math.max(0, max - damageable.getDamage());
            String format = WYG.getInstance().getConfigManager().getDurabilityFormat();
            try {
                return MINI_MESSAGE.deserialize(format, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"current", (String)String.valueOf(current)), Placeholder.parsed((String)"max", (String)String.valueOf(max)), SpriteResolver.forTooltips(item)}));
            }
            catch (Exception e) {
                WYG.getInstance().getLogger().warning("Failed to parse durability format: " + format + " - " + e.getMessage());
                return Component.text((String)(current + "/" + max));
            }
        }
        return null;
    }

    private static List<Component> getEnchantmentLines(ItemStack item, ItemMeta meta) {
        if (meta == null) {
            return List.of();
        }
        Map<Enchantment, Integer> enchantments = TooltipBuilder.getEnchantments(item, meta);
        if (enchantments == null || enchantments.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        String enchantFormat = WYG.getInstance().getConfigManager().getEnchantmentFormat();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Component line;
            TranslatableComponent levelComponent;
            Enchantment enchantment = entry.getKey();
            int level = entry.getValue();
            TranslatableComponent enchantName = Component.translatable((String)("enchantment.minecraft." + enchantment.getKey().getKey()));
            if (level == 1 && enchantment.getMaxLevel() == 1) {
                levelComponent = Component.empty();
                line = MINI_MESSAGE.deserialize(enchantFormat, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"enchantment", (ComponentLike)enchantName), Placeholder.component((String)"level", (ComponentLike)Component.empty()), SpriteResolver.forTooltips(item)}));
                lines.add(line);
                continue;
            }
            levelComponent = Component.translatable((String)("enchantment.level." + level));
            line = MINI_MESSAGE.deserialize(enchantFormat, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"enchantment", (ComponentLike)enchantName), Placeholder.component((String)"level", (ComponentLike)Component.space().append((Component)levelComponent)), SpriteResolver.forTooltips(item)}));
            lines.add(line);
        }
        return lines;
    }

    private static Map<Enchantment, Integer> getEnchantments(ItemStack item, ItemMeta meta) {
        if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            return storageMeta.getStoredEnchants();
        }
        if (meta.hasEnchants()) {
            return meta.getEnchants();
        }
        return null;
    }

    private static List<Component> getLoreLines(ItemMeta meta) {
        if (meta == null || !meta.hasLore()) {
            return List.of();
        }
        List lore = meta.lore();
        if (lore == null || lore.isEmpty()) {
            return List.of();
        }
        return new ArrayList<Component>(lore);
    }

    private static List<Component> getAllAttributeLines(Multimap<Attribute, AttributeModifier> allAttributes, Player sender) {
        if (allAttributes.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            lines.addAll(TooltipBuilder.getSlotAttributeLines(allAttributes, slot, sender));
        }
        return lines;
    }

    private static Multimap<Attribute, AttributeModifier> filterAttributesBySlot(Multimap<Attribute, AttributeModifier> allAttributes, EquipmentSlot slot) {
        ArrayListMultimap slotModifiers = ArrayListMultimap.create();
        for (Map.Entry entry : allAttributes.entries()) {
            if (((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            slotModifiers.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
        return slotModifiers;
    }

    private static double calculateAttributeTotal(Multimap<Attribute, AttributeModifier> modifiers, Attribute attribute, Player sender) {
        double base = TooltipBuilder.getPlayerBaseValue(sender, attribute);
        if (!modifiers.containsKey((Object)attribute)) {
            return base;
        }
        double total = base;
        block4: for (AttributeModifier modifier : modifiers.get((Object)attribute)) {
            AttributeModifier.Operation op = modifier.getOperation();
            double amount = modifier.getAmount();
            switch (op) {
                case ADD_NUMBER: {
                    total += amount;
                    continue block4;
                }
                case ADD_SCALAR: 
                case MULTIPLY_SCALAR_1: {
                    total += base * amount;
                    continue block4;
                }
            }
            total += amount;
        }
        return total;
    }

    private static List<Component> getAttributeTypeLines(Multimap<Attribute, AttributeModifier> allAttributes, String attributeType, boolean includeHeaders, Player sender) {
        if (allAttributes.isEmpty()) {
            return List.of();
        }
        Attribute attribute = TooltipBuilder.parseAttributeType(attributeType);
        if (attribute == null || !allAttributes.containsKey((Object)attribute)) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Multimap<Attribute, AttributeModifier> slotModifiers = TooltipBuilder.filterAttributesBySlot(allAttributes, slot);
            if (!slotModifiers.containsKey((Object)attribute)) continue;
            if (includeHeaders) {
                TooltipBuilder.addSlotHeader(slot, lines);
            }
            TooltipBuilder.addAttributeLineForType(slotModifiers, attribute, attributeType, sender, lines);
        }
        return lines;
    }

    private static Attribute parseAttributeType(String attributeType) {
        return switch (attributeType) {
            case "attack_damage" -> Attribute.ATTACK_DAMAGE;
            case "attack_speed" -> Attribute.ATTACK_SPEED;
            case "armor" -> Attribute.ARMOR;
            case "armor_toughness" -> Attribute.ARMOR_TOUGHNESS;
            case "knockback_resistance" -> Attribute.KNOCKBACK_RESISTANCE;
            default -> null;
        };
    }

    private static EquipmentSlot parseEquipmentSlot(String slotName) {
        return switch (slotName) {
            case "hand" -> EquipmentSlot.HAND;
            case "off_hand" -> EquipmentSlot.OFF_HAND;
            case "head" -> EquipmentSlot.HEAD;
            case "chest" -> EquipmentSlot.CHEST;
            case "legs" -> EquipmentSlot.LEGS;
            case "feet" -> EquipmentSlot.FEET;
            default -> null;
        };
    }

    private static void addSlotHeader(EquipmentSlot slot, List<Component> lines) {
        String slotHeaderFormat = WYG.getInstance().getConfigManager().getAttributeSlotHeaderFormat();
        if (slotHeaderFormat != null && !slotHeaderFormat.trim().isEmpty()) {
            Component slotTranslation = TooltipBuilder.getSlotTranslation(slot);
            Component headerLine = MINI_MESSAGE.deserialize(slotHeaderFormat, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"slot", (ComponentLike)slotTranslation), SpriteResolver.basic()}));
            lines.add(headerLine);
        }
    }

    private static void addAttributeLineForType(Multimap<Attribute, AttributeModifier> modifiers, Attribute attribute, String attributeType, Player sender, List<Component> lines) {
        if (attribute == Attribute.KNOCKBACK_RESISTANCE) {
            double knockbackResistance = TooltipBuilder.calculateAttributeTotal(modifiers, attribute, sender);
            if (knockbackResistance > 0.0) {
                String format = WYG.getInstance().getConfigManager().getAttributeFormat(attributeType);
                TranslatableComponent attributeTranslation = Component.translatable((String)attribute.translationKey());
                Component line = MINI_MESSAGE.deserialize(format, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"value", (String)DECIMAL_FORMAT.format(knockbackResistance * 100.0)), Placeholder.component((String)"attribute", (ComponentLike)attributeTranslation), SpriteResolver.basic()}));
                lines.add(line);
            }
        } else {
            TooltipBuilder.addAttributeLine(modifiers, attribute, attributeType, sender, lines);
        }
    }

    private static List<Component> getSlotAttributeLines(Multimap<Attribute, AttributeModifier> allAttributes, EquipmentSlot slot, Player sender) {
        Multimap<Attribute, AttributeModifier> modifiers = TooltipBuilder.filterAttributesBySlot(allAttributes, slot);
        if (modifiers.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        TooltipBuilder.addSlotHeader(slot, lines);
        TooltipBuilder.addAttributeLine(modifiers, Attribute.ATTACK_DAMAGE, "attack_damage", sender, lines);
        TooltipBuilder.addAttributeLine(modifiers, Attribute.ATTACK_SPEED, "attack_speed", sender, lines);
        TooltipBuilder.addAttributeLine(modifiers, Attribute.ARMOR, "armor", sender, lines);
        TooltipBuilder.addAttributeLine(modifiers, Attribute.ARMOR_TOUGHNESS, "armor_toughness", sender, lines);
        double knockbackResistance = TooltipBuilder.calculateAttributeTotal(modifiers, Attribute.KNOCKBACK_RESISTANCE, sender);
        if (knockbackResistance > 0.0) {
            String format = WYG.getInstance().getConfigManager().getAttributeFormat("knockback_resistance");
            TranslatableComponent attributeTranslation = Component.translatable((String)Attribute.KNOCKBACK_RESISTANCE.translationKey());
            Component line = MINI_MESSAGE.deserialize(format, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"value", (String)DECIMAL_FORMAT.format(knockbackResistance * 100.0)), Placeholder.component((String)"attribute", (ComponentLike)attributeTranslation), SpriteResolver.basic()}));
            lines.add(line);
        }
        return lines;
    }

    private static void addAttributeLine(Multimap<Attribute, AttributeModifier> modifiers, Attribute attribute, String configKey, Player sender, List<Component> lines) {
        if (!modifiers.containsKey((Object)attribute)) {
            return;
        }
        double total = TooltipBuilder.calculateAttributeTotal(modifiers, attribute, sender);
        double base = TooltipBuilder.getPlayerBaseValue(sender, attribute);
        if (attribute == Attribute.ATTACK_DAMAGE && total <= base) {
            return;
        }
        String format = WYG.getInstance().getConfigManager().getAttributeFormat(configKey);
        String valueStr = DECIMAL_FORMAT.format(total);
        TranslatableComponent attributeTranslation = Component.translatable((String)attribute.translationKey());
        Component line = MINI_MESSAGE.deserialize(format, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"value", (String)valueStr), Placeholder.component((String)"attribute", (ComponentLike)attributeTranslation), SpriteResolver.basic()}));
        lines.add(line);
    }

    private static double getPlayerBaseValue(Player sender, Attribute attribute) {
        if (sender != null) {
            try {
                AttributeInstance attrInstance = sender.getAttribute(attribute);
                if (attrInstance != null) {
                    return attrInstance.getBaseValue();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private static Component getSlotTranslation(EquipmentSlot slot) {
        String key = switch (slot) {
            case EquipmentSlot.HAND -> "item.modifiers.mainhand";
            case EquipmentSlot.OFF_HAND -> "item.modifiers.offhand";
            case EquipmentSlot.HEAD -> "item.modifiers.head";
            case EquipmentSlot.CHEST -> "item.modifiers.chest";
            case EquipmentSlot.LEGS -> "item.modifiers.legs";
            case EquipmentSlot.FEET -> "item.modifiers.feet";
            default -> "item.modifiers.mainhand";
        };
        return Component.translatable((String)key);
    }

    private static boolean isEffectivelyBlank(Component component) {
        if (component == null) {
            return true;
        }
        if (Component.empty().equals((Object)component)) {
            return true;
        }
        String plain = PlainTextComponentSerializer.plainText().serialize(component);
        return plain == null || plain.isBlank();
    }

    public static Component createHoverComponent(List<Component> hoverTextLines) {
        if (hoverTextLines.isEmpty()) {
            return Component.empty();
        }
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < hoverTextLines.size(); ++i) {
            if (i > 0) {
                builder.append((Component)Component.newline());
            }
            builder.append(hoverTextLines.get(i));
        }
        return builder.build();
    }
}

