/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.schematic;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.schematic.SchematicBlockObject;
import com.natamus.collective_common_neoforge.schematic.SchematicFunctions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<CompoundTag> blockEntities;
    private List<Pair<BlockPos, CompoundTag>> entities;
    private boolean parsedCorrectly = false;

    public Schematic(InputStream inputStream) {
        new Schematic(inputStream, null);
    }

    public Schematic(InputStream inputStream, Level level) {
        DefaultedRegistry blockRegistry = BuiltInRegistries.BLOCK;
        if (level != null) {
            blockRegistry = level.registryAccess().lookupOrThrow(Registries.BLOCK);
        }
        String type = "";
        try {
            CompoundTag nbtdata = SchematicFunctions.readCompressed(inputStream);
            inputStream.close();
            if (nbtdata.contains("Schematic")) {
                nbtdata = nbtdata.getCompoundOrEmpty("Schematic");
            }
            if (nbtdata.contains("Length")) {
                this.width = (Short)nbtdata.getShort("Width").get();
                this.height = (Short)nbtdata.getShort("Height").get();
                this.length = (Short)nbtdata.getShort("Length").get();
            } else {
                ListTag sizeList = (ListTag)nbtdata.getList("size").get();
                this.width = (Short)sizeList.getShort(0).get();
                this.height = (Short)sizeList.getShort(1).get();
                this.length = (Short)sizeList.getShort(2).get();
            }
            this.size = this.width * this.height * this.length;
            type = nbtdata.contains("entities") ? "nbt" : (nbtdata.contains("DataVersion") ? "schem" : "schematic");
            this.blockObjects = new SchematicBlockObject[this.size];
            this.entities = new ArrayList<Pair<BlockPos, CompoundTag>>();
            switch (type) {
                case "schem": {
                    ListTag tileentitynbtlist;
                    CompoundTag palette;
                    byte[] blockDataRaw;
                    int[] blockData = new int[this.width * this.height * this.length];
                    if (nbtdata.getIntOr("Version", 2) == 2) {
                        blockDataRaw = (byte[])nbtdata.getByteArray("BlockData").get();
                        palette = (CompoundTag)nbtdata.getCompound("Palette").get();
                        tileentitynbtlist = (ListTag)nbtdata.getList("BlockEntities").get();
                        CompoundTag offsetCompoundTag = (CompoundTag)nbtdata.getCompound("Metadata").get();
                        this.offsetX = (Integer)offsetCompoundTag.getInt("WEOffsetX").get();
                        this.offsetY = (Integer)offsetCompoundTag.getInt("WEOffsetY").get();
                        this.offsetZ = (Integer)offsetCompoundTag.getInt("WEOffsetZ").get();
                    } else {
                        CompoundTag blocksCompoundTag = nbtdata.getCompoundOrEmpty("Blocks");
                        blockDataRaw = (byte[])blocksCompoundTag.getByteArray("Data").get();
                        palette = (CompoundTag)blocksCompoundTag.getCompound("Palette").get();
                        tileentitynbtlist = (ListTag)blocksCompoundTag.getList("BlockEntities").get();
                        int[] offsetArray = (int[])nbtdata.getIntArray("Offset").get();
                        this.offsetX = offsetArray[0];
                        this.offsetY = offsetArray[1];
                        this.offsetZ = offsetArray[2];
                    }
                    int index = 0;
                    int i = 0;
                    while (i < blockDataRaw.length) {
                        int value = 0;
                        int varintLength = 0;
                        while (true) {
                            value |= (blockDataRaw[i] & 0x7F) << varintLength++ * 7;
                            if (varintLength > 5) continue;
                            if ((blockDataRaw[i] & 0x80) != 128) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        blockData[index] = value;
                        ++index;
                    }
                    this.palette = new HashMap();
                    for (String k : palette.keySet()) {
                        this.palette.put((Integer)palette.getInt(k).get(), k);
                    }
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                int id = blockData[counter];
                                if (id < 0) {
                                    id *= -1;
                                }
                                BlockState state = this.getStateFromID((Registry<Block>)blockRegistry, id);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    this.blockEntities = new ArrayList<CompoundTag>();
                    for (int t = 0; t < tileentitynbtlist.size(); ++t) {
                        this.blockEntities.add((CompoundTag)tileentitynbtlist.getCompound(t).get());
                    }
                    this.parsedCorrectly = true;
                    return;
                }
                case "schematic": {
                    byte[] blockIDs_byte = (byte[])nbtdata.getByteArray("Blocks").get();
                    int[] blockIDs = new int[this.size];
                    for (int x = 0; x < blockIDs_byte.length; ++x) {
                        blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                    }
                    byte[] metadata = (byte[])nbtdata.getByteArray("Data").get();
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                BlockState state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    ListTag tileentitynbtlist = (ListTag)nbtdata.getList("TileEntities").get();
                    this.blockEntities = new ArrayList<CompoundTag>();
                    for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                        CompoundTag compound = (CompoundTag)tileentitynbtlist.getCompound(i).get();
                        int i0 = (Integer)compound.getInt("x").get();
                        int i1 = (Integer)compound.getInt("y").get();
                        int i2 = (Integer)compound.getInt("z").get();
                        compound.putIntArray("Pos", new int[]{i0, i1, i2});
                        this.blockEntities.add(compound);
                    }
                    this.offsetX = (Integer)nbtdata.getInt("WEOffsetX").get();
                    this.offsetY = (Integer)nbtdata.getInt("WEOffsetY").get();
                    this.offsetZ = (Integer)nbtdata.getInt("WEOffsetZ").get();
                    this.parsedCorrectly = true;
                    return;
                }
                case "nbt": {
                    ListTag paletteNBTList = (ListTag)nbtdata.getList("palette").get();
                    this.palette = new HashMap();
                    for (int i = 0; i < paletteNBTList.size(); ++i) {
                        CompoundTag compound = (CompoundTag)paletteNBTList.getCompound(i).get();
                        Object value = (String)compound.getString("Name").get();
                        if (compound.contains("Properties")) {
                            StringBuilder metaData = new StringBuilder("[");
                            CompoundTag propertyCompound = (CompoundTag)compound.getCompound("Properties").get();
                            for (String propertyKey : propertyCompound.keySet()) {
                                if (!metaData.toString().equals("[")) {
                                    metaData.append(",");
                                }
                                metaData.append(propertyKey).append("=").append(propertyCompound.get(propertyKey));
                            }
                            metaData.append("]");
                            value = (String)value + String.valueOf(metaData);
                        }
                        this.palette.put(i, (String)value);
                    }
                    this.blockEntities = new ArrayList<CompoundTag>();
                    ListTag blocksNBTList = (ListTag)nbtdata.getList("blocks").get();
                    for (int i = 0; i < blocksNBTList.size(); ++i) {
                        CompoundTag compound = (CompoundTag)blocksNBTList.getCompound(i).get();
                        ListTag posList = (ListTag)compound.getList("pos").get();
                        int i0 = (Integer)posList.getInt(0).get();
                        int i1 = (Integer)posList.getInt(1).get();
                        int i2 = (Integer)posList.getInt(2).get();
                        BlockPos pos = new BlockPos(i0, i1, i2);
                        BlockState state = this.getStateFromID((Registry<Block>)blockRegistry, (Integer)compound.getInt("state").get());
                        this.blockObjects[i] = new SchematicBlockObject(pos, state);
                        if (!compound.contains("nbt")) continue;
                        CompoundTag blockEntityCompound = (CompoundTag)compound.getCompound("nbt").get();
                        blockEntityCompound.putIntArray("Pos", new int[]{i0, i1, i2});
                        blockEntityCompound.putString("Id", (String)blockEntityCompound.getString("id").get());
                        blockEntityCompound.remove("id");
                        this.blockEntities.add(blockEntityCompound);
                    }
                    ListTag entitiesNBTList = (ListTag)nbtdata.getList("entities").get();
                    for (int i = 0; i < entitiesNBTList.size(); ++i) {
                        CompoundTag compound = (CompoundTag)entitiesNBTList.getCompound(i).get();
                        CompoundTag entityCompound = (CompoundTag)compound.getCompound("nbt").get();
                        ListTag posList = (ListTag)compound.getList("blockPos").get();
                        int i0 = (Integer)posList.getInt(0).get();
                        int i1 = (Integer)posList.getInt(1).get();
                        int i2 = (Integer)posList.getInt(2).get();
                        this.entities.add((Pair<BlockPos, CompoundTag>)new Pair((Object)new BlockPos(i0, i1, i2), (Object)entityCompound));
                    }
                    this.offsetX = 0;
                    this.offsetY = 0;
                    this.offsetZ = 0;
                    this.parsedCorrectly = true;
                    return;
                }
            }
        }
        catch (Exception ignored) {
            Constants.LOG.warn("[Collective] Something went wrong while parsing the schematic.");
        }
        Constants.LOG.warn("Can't load {} Schematic file.", (Object)type);
        this.width = 0;
        this.height = 0;
        this.length = 0;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        this.size = 0;
        this.blockObjects = null;
        this.palette = null;
        this.blockEntities = null;
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private BlockState getStateFromOldIds(int blockID, byte meta) {
        return Block.stateById((int)blockID);
    }

    public BlockState getBlockState(BlockPos pos) {
        for (SchematicBlockObject schematicBlockObject : this.blockObjects) {
            if (!schematicBlockObject.getPosition().equals((Object)pos)) continue;
            return schematicBlockObject.getState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public BlockState getStateFromID(Registry<Block> blockRegistry, int id) {
        String iblockstateS = this.palette.get(id);
        try {
            return BlockStateParser.parseForBlock(blockRegistry, (StringReader)new StringReader(iblockstateS), (boolean)false).blockState();
        }
        catch (Exception ex) {
            return Blocks.AIR.defaultBlockState();
        }
    }

    public List<CompoundTag> getBlockEntities() {
        return this.blockEntities;
    }

    public List<Pair<BlockPos, CompoundTag>> getEntityRelativePosPairs() {
        return this.entities;
    }

    public CompoundTag getTileEntity(BlockPos pos) {
        for (CompoundTag compound : this.blockEntities) {
            int[] pos1 = (int[])compound.getIntArray("Pos").get();
            if (pos1[0] != pos.getX() || pos1[1] != pos.getY() || pos1[2] != pos.getZ()) continue;
            return compound;
        }
        return null;
    }

    public BlockPos getBlockPosFromCompoundTag(CompoundTag compoundTag) {
        int[] pos = (int[])compoundTag.getIntArray("Pos").get();
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public boolean wasParsedCorrectly() {
        return this.parsedCorrectly;
    }
}

