/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective;

import com.natamus.collective.forge.config.ForgeCollectiveConfigScreen;
import com.natamus.collective.forge.events.RegisterCollectiveForgeClientEvents;
import com.natamus.collective.forge.events.RegisterCollectiveForgeEvents;
import com.natamus.collective.forge.networking.ForgeNetworkHandler;
import com.natamus.collective.forge.services.ForgeRegisterItemHelper;
import com.natamus.collective.forge.services.ForgeRegisterKeyMappingHelper;
import com.natamus.collective_common_forge.CollectiveCommon;
import com.natamus.collective_common_forge.check.RegisterMod;
import com.natamus.collective_common_forge.implementations.networking.NetworkSetup;
import com.natamus.collective_common_forge.implementations.networking.data.Side;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="collective")
public class CollectiveForge {
    public static CollectiveForge instance;

    public CollectiveForge(FMLJavaModLoadingContext modLoadingContext) {
        instance = this;
        CollectiveForge.setGlobalConstants();
        CollectiveCommon.init();
        ForgeCollectiveConfigScreen.registerScreen((ModLoadingContext)modLoadingContext);
        BusGroup busGroup = modLoadingContext.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)busGroup).addListener(this::commonSetupEvent);
        FMLLoadCompleteEvent.getBus((BusGroup)busGroup).addListener(this::loadComplete);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)busGroup).addListener(ForgeRegisterItemHelper::addItemsToCreativeInventory);
        RegisterKeyMappingsEvent.getBus((BusGroup)busGroup).addListener(ForgeRegisterKeyMappingHelper::registerKeyMappings);
        RegisterMod.register("Collective", "collective", "8.10", "[1.21.8]");
    }

    private void commonSetupEvent(FMLCommonSetupEvent event) {
        new NetworkSetup(new ForgeNetworkHandler(FMLLoader.getDist().isClient() ? Side.CLIENT : Side.SERVER));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        RegisterCollectiveForgeEvents.registerEventsInBus();
        if (FMLEnvironment.dist.equals((Object)Dist.CLIENT)) {
            RegisterCollectiveForgeClientEvents.registerEventsInBus();
        }
    }

    private static void setGlobalConstants() {
    }
}

