/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;

public class CompareItemFunctions {
    public static boolean itemIsInRegistryHolder(Item item, TagKey<Item> tagKey) {
        return item.builtInRegistryHolder().is(tagKey);
    }

    public static boolean isSapling(Item item) {
        return CompareItemFunctions.itemIsInRegistryHolder(item, (TagKey<Item>)ItemTags.SAPLINGS) || Block.byItem((Item)item) instanceof SaplingBlock;
    }

    public static boolean isSapling(ItemStack itemstack) {
        return CompareItemFunctions.isSapling(itemstack.getItem());
    }

    public static boolean isLog(Item item) {
        return CompareItemFunctions.itemIsInRegistryHolder(item, (TagKey<Item>)ItemTags.LOGS);
    }

    public static boolean isLog(ItemStack itemstack) {
        return CompareItemFunctions.isLog(itemstack.getItem());
    }

    public static boolean isPlank(Item item) {
        return CompareItemFunctions.itemIsInRegistryHolder(item, (TagKey<Item>)ItemTags.PLANKS);
    }

    public static boolean isPlank(ItemStack itemstack) {
        return CompareItemFunctions.isPlank(itemstack.getItem());
    }

    public static boolean isChest(Item item) {
        Block block = Block.byItem((Item)item);
        return block.equals(Blocks.CHEST) || block.equals(Blocks.TRAPPED_CHEST);
    }

    public static boolean isChest(ItemStack itemstack) {
        return CompareItemFunctions.isChest(itemstack.getItem());
    }

    public static boolean isStone(Item item) {
        return CompareItemFunctions.itemIsInRegistryHolder(item, (TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS);
    }

    public static boolean isStone(ItemStack itemstack) {
        return CompareItemFunctions.isStone(itemstack.getItem());
    }

    public static boolean isSlab(Item item) {
        return CompareItemFunctions.itemIsInRegistryHolder(item, (TagKey<Item>)ItemTags.SLABS);
    }

    public static boolean isSlab(ItemStack itemstack) {
        return CompareItemFunctions.isSlab(itemstack.getItem());
    }
}

