/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.beehave.command;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.beehave.Beehave;
import cool.muyucloud.beehave.config.Config;
import cool.muyucloud.beehave.util.TranslatorManager;
import java.io.Serializable;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class PropertySubCommand {
    private static final Config CONFIG = Beehave.CONFIG;
    private static final Config DEFAULT_CONFIG = Beehave.DEFAULT_CONFIG;
    private static final TranslatorManager TRANSLATOR = Beehave.TRANSLATOR;

    public static void register(LiteralArgumentBuilder<class_2168> parent) {
        for (String key : DEFAULT_CONFIG.getProperties()) {
            LiteralArgumentBuilder nodeKey = class_2170.method_9247((String)key);
            nodeKey.executes(context -> PropertySubCommand.get((class_2168)context.getSource(), key));
            Class<? extends Serializable> type = DEFAULT_CONFIG.getType(key);
            RequiredArgumentBuilder<class_2168, ? extends Serializable> nodeValue = PropertySubCommand.genNodeValue(key, type);
            LiteralArgumentBuilder<class_2168> nodeDefault = PropertySubCommand.genNodeDefault(key, type);
            nodeKey.then(nodeValue);
            nodeKey.then(nodeDefault);
            parent.then((ArgumentBuilder)nodeKey);
        }
    }

    @NotNull
    private static LiteralArgumentBuilder<class_2168> genNodeDefault(String key, Class<? extends Serializable> type) {
        LiteralArgumentBuilder nodeDefault = class_2170.method_9247((String)"default");
        nodeDefault.executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            JsonPrimitive value = PropertySubCommand.primitiveProperty(key, type);
            return PropertySubCommand.set(source, key, value);
        });
        return nodeDefault;
    }

    private static JsonPrimitive primitiveProperty(String key, Class<? extends Serializable> type) {
        if (type == Number.class) {
            Integer value = DEFAULT_CONFIG.getAsInt(key);
            return new JsonPrimitive((Number)value);
        }
        if (type == Boolean.class) {
            Boolean value = DEFAULT_CONFIG.getAsBoolean(key);
            return new JsonPrimitive(value);
        }
        if (type == String.class) {
            String value = DEFAULT_CONFIG.getAsString(key);
            return new JsonPrimitive(value);
        }
        return null;
    }

    @NotNull
    private static RequiredArgumentBuilder<class_2168, ? extends Serializable> genNodeValue(String key, Class<? extends Serializable> type) {
        ArgumentType<? extends Serializable> argumentType = PropertySubCommand.argumentType(type);
        RequiredArgumentBuilder nodeValue = class_2170.method_9244((String)"key", argumentType);
        nodeValue.executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            JsonPrimitive value = PropertySubCommand.readArgument(type, (CommandContext<class_2168>)context, "key");
            return PropertySubCommand.set(source, key, value);
        });
        return nodeValue;
    }

    private static ArgumentType<? extends Serializable> argumentType(Class<? extends Serializable> type) {
        if (type == Number.class) {
            return IntegerArgumentType.integer();
        }
        if (type == Boolean.class) {
            return BoolArgumentType.bool();
        }
        if (type == String.class) {
            return StringArgumentType.string();
        }
        return null;
    }

    private static JsonPrimitive readArgument(Class<? extends Serializable> type, CommandContext<class_2168> context, String name) {
        if (type == Number.class) {
            Integer value = IntegerArgumentType.getInteger(context, (String)name);
            return new JsonPrimitive((Number)value);
        }
        if (type == Boolean.class) {
            Boolean value = BoolArgumentType.getBool(context, (String)name);
            return new JsonPrimitive(value);
        }
        if (type == String.class) {
            String value = StringArgumentType.getString(context, (String)name);
            return new JsonPrimitive(value);
        }
        return null;
    }

    private static int set(class_2168 source, String key, JsonPrimitive value) {
        if (CONFIG.set(key, value)) {
            class_5250 text = TRANSLATOR.translate("message.command.beehave.property.set.success", key, value.getAsString());
            source.method_9226(() -> text, false);
            return 1;
        }
        class_5250 text = TRANSLATOR.translate("message.command.beehave.property.set.fail", key, value.getAsString());
        source.method_9213((class_2561)text);
        return 0;
    }

    private static int get(class_2168 source, String key) {
        String value = CONFIG.getAsString(key);
        if (value != null) {
            class_5250 text = TRANSLATOR.translate("message.command.beehave.property.get.success", key, value);
            source.method_9226(() -> text, false);
            return 1;
        }
        class_5250 text = TRANSLATOR.translate("message.command.beehave.property.get.failure", key);
        source.method_9213((class_2561)text);
        return 0;
    }
}

