/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.beehave.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cool.muyucloud.beehave.Beehave;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Path CONFIG_PATH = Path.of("config", new String[0]).resolve("beehave.json");
    private static final Logger LOGGER = Beehave.LOGGER;
    private final JsonObject content = new JsonObject();

    public Config() {
        this.content.addProperty("beehive", Boolean.valueOf(true));
        this.content.addProperty("bee", Boolean.valueOf(true));
        this.content.addProperty("lang", "en_us");
    }

    private static Config createAndLoad() {
        Config config = new Config();
        config.load();
        return config;
    }

    public boolean load() {
        if (!Config.tryDeployFile()) {
            return false;
        }
        this.readFile();
        this.dump();
        return true;
    }

    public boolean save() {
        if (!Config.tryDeployFile()) {
            return false;
        }
        this.dump();
        return true;
    }

    private void dump() {
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.content);
        try (OutputStream outputStream = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
            outputStream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Cannot dump settings to file");
            LOGGER.error((Object)e);
        }
    }

    public Set<String> getProperties() {
        HashSet<String> out = new HashSet<String>();
        for (String key : this.content.keySet()) {
            if (this.content.get(key).isJsonArray()) continue;
            out.add(key);
        }
        return out;
    }

    public Class<? extends Serializable> getType(String key) {
        if (!this.content.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.content.getAsJsonPrimitive(key);
        if (primitive.isBoolean()) {
            return Boolean.class;
        }
        if (primitive.isNumber()) {
            return Number.class;
        }
        if (primitive.isString()) {
            return String.class;
        }
        return null;
    }

    public String getAsString(String key) {
        if (!this.content.has(key)) {
            return null;
        }
        return this.content.getAsJsonPrimitive(key).getAsString();
    }

    public Boolean getAsBoolean(String key) {
        JsonPrimitive primitive = this.content.getAsJsonPrimitive(key);
        return primitive == null ? null : (primitive.isBoolean() ? Boolean.valueOf(primitive.getAsBoolean()) : null);
    }

    public Integer getAsInt(String key) {
        JsonPrimitive primitive = this.content.getAsJsonPrimitive(key);
        return primitive == null ? null : (primitive.isNumber() ? Integer.valueOf(primitive.getAsInt()) : null);
    }

    public boolean set(String key, JsonPrimitive value) {
        if (!this.content.has(key)) {
            return false;
        }
        JsonPrimitive dst = this.content.getAsJsonPrimitive(key);
        if (value.isNumber() && !dst.isNumber()) {
            return false;
        }
        if (value.isBoolean() && !dst.isBoolean()) {
            return false;
        }
        if (value.isString() && !dst.isString()) {
            return false;
        }
        this.content.add(key, (JsonElement)value);
        return true;
    }

    private static boolean tryDeployFile() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            LOGGER.info("beehave.json does not exist, generating.");
            try {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to generate config file at %s.".formatted(CONFIG_PATH));
                LOGGER.error((Object)e);
                return false;
            }
        }
        return true;
    }

    private void readFile() {
        try (InputStream stream = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            JsonObject object = (JsonObject)new Gson().fromJson(new String(stream.readAllBytes(), StandardCharsets.UTF_8), JsonObject.class);
            this.readConfig(object);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config from file");
        }
    }

    private void readConfig(JsonObject object) {
        try {
            this.readProperties(object);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config from file");
        }
    }

    private void readProperties(JsonObject object) {
        for (String key : object.keySet()) {
            if (!this.content.has(key)) continue;
            JsonPrimitive dst = this.content.getAsJsonPrimitive(key);
            JsonPrimitive src = object.getAsJsonPrimitive(key);
            if (dst.isBoolean()) {
                this.content.addProperty(key, Boolean.valueOf(src.getAsBoolean()));
                continue;
            }
            if (dst.isNumber()) {
                this.content.addProperty(key, src.getAsNumber());
                continue;
            }
            if (dst.isString()) {
                this.content.addProperty(key, src.getAsString());
                continue;
            }
            this.readItemArray(key, object);
        }
    }

    private void readItemArray(String key, JsonObject object) {
        this.content.remove(key);
        JsonArray dst = this.content.getAsJsonArray(key);
        JsonArray src = object.getAsJsonArray(key);
        for (JsonElement element : src) {
            class_2960 id = class_2960.method_60654((String)element.getAsString());
            if (!class_7923.field_41178.method_10250(id)) continue;
            dst.add(id.toString());
        }
    }
}

