/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.kotlin_shadedx.datetime;

import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.jetbrains.annotations.NotNull;
import sh.sit.plp.kotlin_shaded.Deprecated;
import sh.sit.plp.kotlin_shaded.DeprecationLevel;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.NoWhenBranchMatchedException;
import sh.sit.plp.kotlin_shaded.ReplaceWith;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimeArithmeticException;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimePeriod;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimePeriodKt;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimeUnit;
import sh.sit.plp.kotlin_shadedx.datetime.Instant;
import sh.sit.plp.kotlin_shadedx.datetime.InstantJvmKt;
import sh.sit.plp.kotlin_shadedx.datetime.InstantKt;
import sh.sit.plp.kotlin_shadedx.datetime.TimeZone;
import sh.sit.plp.kotlin_shadedx.datetime.internal.DivRemResult;
import sh.sit.plp.kotlin_shadedx.datetime.internal.MathJvmKt;
import sh.sit.plp.kotlin_shadedx.datetime.internal.MathKt;

@Metadata(mv={2, 1, 0}, k=5, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\b\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a$\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a$\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a$\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0007\u001a\u001c\u0010\u0011\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a$\u0010\u0013\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\u0014"}, d2={"atZone", "Ljava/time/ZonedDateTime;", "Lsh/sit/plp/kotlin_shadedx/datetime/Instant;", "zone", "Lsh/sit/plp/kotlin_shadedx/datetime/TimeZone;", "atZone$InstantJvmKt__DeprecatedInstantKt", "plus", "period", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimePeriod;", "timeZone", "unit", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit;", "value", "", "minus", "", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "periodUntil", "other", "until", "sh.sit.plp.kotlin_shadedx-datetime"}, xs="sh/sit/plp/kotlin_shadedx/datetime/InstantJvmKt")
@SourceDebugExtension(value={"SMAP\nDeprecatedInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedInstant.kt\nkotlinx/datetime/InstantJvmKt__DeprecatedInstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
final class InstantJvmKt__DeprecatedInstantKt {
    private static final ZonedDateTime atZone$InstantJvmKt__DeprecatedInstantKt(Instant $this$atZone, TimeZone zone) {
        ZonedDateTime zonedDateTime;
        try {
            zonedDateTime = $this$atZone.getValue$kotlinx_datetime().atZone(zone.getZoneId$kotlinx_datetime());
            Intrinsics.checkNotNull(zonedDateTime);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
        return zonedDateTime;
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().plus(period, timeZone).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(period, "period");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        try {
            ZonedDateTime thisZdt = InstantJvmKt__DeprecatedInstantKt.atZone$InstantJvmKt__DeprecatedInstantKt($this$plus, timeZone);
            DateTimePeriod $this$plus_u24lambda_u243 = period;
            boolean bl = false;
            ZonedDateTime $this$plus_u24lambda_u243_u24lambda_u240 = thisZdt;
            boolean bl2 = false;
            ZonedDateTime $this$plus_u24lambda_u243_u24lambda_u241 = $this$plus_u24lambda_u243.getTotalMonths$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u243_u24lambda_u240.plusMonths($this$plus_u24lambda_u243.getTotalMonths$kotlinx_datetime()) : $this$plus_u24lambda_u243_u24lambda_u240;
            boolean bl3 = false;
            ZonedDateTime $this$plus_u24lambda_u243_u24lambda_u242 = $this$plus_u24lambda_u243.getDays() != 0 ? $this$plus_u24lambda_u243_u24lambda_u241.plusDays($this$plus_u24lambda_u243.getDays()) : $this$plus_u24lambda_u243_u24lambda_u241;
            boolean bl4 = false;
            java.time.Instant p0 = ($this$plus_u24lambda_u243.getTotalNanoseconds$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u243_u24lambda_u242.plusNanos($this$plus_u24lambda_u243.getTotalNanoseconds$kotlinx_datetime()) : $this$plus_u24lambda_u243_u24lambda_u242).toInstant();
            boolean bl5 = false;
            return new Instant(p0);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().plus(1, unit, timeZone).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$plus, 1L, unit, timeZone);
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().plus(value, unit, timeZone).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$plus, (long)value, unit, timeZone);
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().minus(value, unit, timeZone).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, int value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$minus, -((long)value), unit, timeZone);
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().plus(value, unit, timeZone).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, long value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        try {
            java.time.Instant instant2;
            ZonedDateTime thisZdt = InstantJvmKt__DeprecatedInstantKt.atZone$InstantJvmKt__DeprecatedInstantKt($this$plus, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                java.time.Instant instant3;
                java.time.Instant it = instant3 = InstantJvmKt.plus($this$plus, value, (DateTimeUnit.TimeBased)unit).getValue$kotlinx_datetime();
                boolean bl = false;
                it.atZone(timeZone.getZoneId$kotlinx_datetime());
                instant2 = instant3;
            } else if (dateTimeUnit instanceof DateTimeUnit.DayBased) {
                instant2 = thisZdt.plusDays(MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.DayBased)unit).getDays())).toInstant();
            } else if (dateTimeUnit instanceof DateTimeUnit.MonthBased) {
                instant2 = thisZdt.plusMonths(MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.MonthBased)unit).getMonths())).toInstant();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            java.time.Instant p0 = instant2;
            boolean bl = false;
            instant = new Instant(p0);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            throw new DateTimeArithmeticException("Instant " + $this$plus + " cannot be represented as local date when adding " + value + ' ' + unit + " to it", e);
        }
        return instant;
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().plus(value, unit).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, long value, @NotNull DateTimeUnit.TimeBased unit) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        try {
            DivRemResult divRemResult = MathKt.multiplyAndDivide(value, unit.getNanoseconds(), 1000000000L);
            boolean bl = false;
            long d = divRemResult.component1();
            long r = divRemResult.component2();
            java.time.Instant instant2 = $this$plus.getValue$kotlinx_datetime().plusSeconds(d).plusNanos(r);
            Intrinsics.checkNotNullExpressionValue(instant2, "plusNanos(...)");
            instant = new Instant(instant2);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            instant = value > 0L ? Instant.Companion.getMAX$kotlinx_datetime() : Instant.Companion.getMIN$kotlinx_datetime();
        }
        return instant;
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().periodUntil(other.toStdlibInstant(), timeZone)", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final DateTimePeriod periodUntil(@NotNull Instant $this$periodUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$periodUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        ZonedDateTime thisZdt = InstantJvmKt__DeprecatedInstantKt.atZone$InstantJvmKt__DeprecatedInstantKt($this$periodUntil, timeZone);
        ZonedDateTime otherZdt = InstantJvmKt__DeprecatedInstantKt.atZone$InstantJvmKt__DeprecatedInstantKt(other, timeZone);
        long months = thisZdt.until(otherZdt, ChronoUnit.MONTHS);
        ZonedDateTime zonedDateTime = thisZdt.plusMonths(months);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "plusMonths(...)");
        thisZdt = zonedDateTime;
        long days = thisZdt.until(otherZdt, ChronoUnit.DAYS);
        ZonedDateTime zonedDateTime2 = thisZdt.plusDays(days);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime2, "plusDays(...)");
        thisZdt = zonedDateTime2;
        long nanoseconds = thisZdt.until(otherZdt, ChronoUnit.NANOS);
        return DateTimePeriodKt.buildDateTimePeriod(months, (int)days, nanoseconds);
    }

    @Deprecated(message="sh.sit.plp.kotlin_shadedx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().until(other.toStdlibInstant(), unit, timeZone)", imports={}), level=DeprecationLevel.WARNING)
    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        long l;
        Intrinsics.checkNotNullParameter($this$until, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        try {
            long l2;
            ZonedDateTime thisZdt = InstantJvmKt__DeprecatedInstantKt.atZone$InstantJvmKt__DeprecatedInstantKt($this$until, timeZone);
            ZonedDateTime otherZdt = InstantJvmKt__DeprecatedInstantKt.atZone$InstantJvmKt__DeprecatedInstantKt(other, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                l2 = InstantKt.until($this$until, other, (DateTimeUnit.TimeBased)unit);
            } else if (dateTimeUnit instanceof DateTimeUnit.DayBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.DAYS) / (long)((DateTimeUnit.DayBased)unit).getDays();
            } else if (dateTimeUnit instanceof DateTimeUnit.MonthBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.MONTHS) / (long)((DateTimeUnit.MonthBased)unit).getMonths();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            l = l2;
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
        catch (ArithmeticException e) {
            l = $this$until.getValue$kotlinx_datetime().compareTo(other.getValue$kotlinx_datetime()) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }
}

