/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.kotlin_shadedx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.Unit;
import sh.sit.plp.kotlin_shaded.jvm.functions.Function1;
import sh.sit.plp.kotlin_shaded.jvm.internal.DefaultConstructorMarker;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shadedx.datetime.ConvertersKt;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimeFormatException;
import sh.sit.plp.kotlin_shadedx.datetime.LocalDate;
import sh.sit.plp.kotlin_shadedx.datetime.LocalDateRange;
import sh.sit.plp.kotlin_shadedx.datetime.Month;
import sh.sit.plp.kotlin_shadedx.datetime.Ser;
import sh.sit.plp.kotlin_shadedx.datetime.YearMonthJvmKt;
import sh.sit.plp.kotlin_shadedx.datetime.YearMonthRange;
import sh.sit.plp.kotlin_shadedx.datetime.format.DateTimeFormat;
import sh.sit.plp.kotlin_shadedx.datetime.format.DateTimeFormatBuilder;
import sh.sit.plp.kotlin_shadedx.datetime.format.YearMonthFormat;
import sh.sit.plp.kotlin_shadedx.datetime.format.YearMonthFormatKt;
import sh.sit.plp.kotlin_shadedx.datetime.internal.UtilKt;
import sh.sit.plp.kotlin_shadedx.datetime.serializers.YearMonthSerializer;
import sh.sit.plp.kotlin_shadedx.serialization.KSerializer;

@sh.sit.plp.kotlin_shadedx.serialization.Serializable(with=YearMonthSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u000223B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0013\u0010)\u001a\u00020*2\b\u0010&\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u0010,\u001a\u00020\bH\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020+H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\t\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00064"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/YearMonth;", "", "Ljava/io/Serializable;", "value", "Ljava/time/YearMonth;", "<init>", "(Ljava/time/YearMonth;)V", "year", "", "month", "(II)V", "Lsh/sit/plp/kotlin_shadedx/datetime/Month;", "(ILsh/sit/plp/kotlin_shadedx/datetime/Month;)V", "getValue$kotlinx_datetime", "()Ljava/time/YearMonth;", "getYear", "()I", "monthNumber", "getMonthNumber$kotlinx_datetime", "getMonth", "()Lsh/sit/plp/kotlin_shadedx/datetime/Month;", "firstDay", "Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;", "getFirstDay", "()Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;", "lastDay", "getLastDay", "numberOfDays", "getNumberOfDays", "days", "Lsh/sit/plp/kotlin_shadedx/datetime/LocalDateRange;", "getDays", "()Lsh/sit/plp/kotlin_shadedx/datetime/LocalDateRange;", "rangeTo", "Lsh/sit/plp/kotlin_shadedx/datetime/YearMonthRange;", "that", "rangeUntil", "compareTo", "other", "toString", "", "equals", "", "", "hashCode", "readObject", "", "ois", "Ljava/io/ObjectInputStream;", "writeReplace", "Companion", "Formats", "sh.sit.plp.kotlin_shadedx-datetime"})
public final class YearMonth
implements Comparable<YearMonth>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.YearMonth value;
    private static final long serialVersionUID = 0L;

    public YearMonth(@NotNull java.time.YearMonth value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.YearMonth getValue$kotlinx_datetime() {
        return this.value;
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber$kotlinx_datetime() {
        return this.value.getMonthValue();
    }

    @NotNull
    public final Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue(month2, "getMonth(...)");
        return ConvertersKt.toKotlinMonth(month2);
    }

    @NotNull
    public final LocalDate getFirstDay() {
        java.time.LocalDate localDate = this.value.atDay(1);
        Intrinsics.checkNotNullExpressionValue(localDate, "atDay(...)");
        return new LocalDate(localDate);
    }

    @NotNull
    public final LocalDate getLastDay() {
        java.time.LocalDate localDate = this.value.atEndOfMonth();
        Intrinsics.checkNotNullExpressionValue(localDate, "atEndOfMonth(...)");
        return new LocalDate(localDate);
    }

    public final int getNumberOfDays() {
        return this.value.lengthOfMonth();
    }

    @NotNull
    public final LocalDateRange getDays() {
        return this.getFirstDay().rangeTo(this.getLastDay());
    }

    /*
     * WARNING - void declaration
     */
    public YearMonth(int year2, int month2) {
        java.time.YearMonth yearMonth;
        YearMonth yearMonth2;
        YearMonth yearMonth3 = this;
        try {
            yearMonth2 = yearMonth3;
            yearMonth = java.time.YearMonth.of(year2, month2);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            YearMonth yearMonth4 = yearMonth3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.YearMonth yearMonth5 = yearMonth;
        Intrinsics.checkNotNull(yearMonth5);
        yearMonth2(yearMonth5);
    }

    /*
     * WARNING - void declaration
     */
    public YearMonth(int year2, @NotNull Month month2) {
        java.time.YearMonth yearMonth;
        YearMonth yearMonth2;
        Intrinsics.checkNotNullParameter((Object)month2, "month");
        YearMonth yearMonth3 = this;
        try {
            yearMonth2 = yearMonth3;
            yearMonth = java.time.YearMonth.of(year2, ConvertersKt.toJavaMonth(month2));
        }
        catch (DateTimeException dateTimeException) {
            void e;
            YearMonth yearMonth4 = yearMonth3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.YearMonth yearMonth5 = yearMonth;
        Intrinsics.checkNotNull(yearMonth5);
        yearMonth2(yearMonth5);
    }

    @NotNull
    public final YearMonthRange rangeTo(@NotNull YearMonth that) {
        Intrinsics.checkNotNullParameter(that, "that");
        return YearMonthRange.Companion.fromRangeTo$kotlinx_datetime(this, that);
    }

    @NotNull
    public final YearMonthRange rangeUntil(@NotNull YearMonth that) {
        Intrinsics.checkNotNullParameter(that, "that");
        return YearMonthRange.Companion.fromRangeUntil$kotlinx_datetime(this, that);
    }

    @Override
    public int compareTo(@NotNull YearMonth other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    @NotNull
    public String toString() {
        String string = YearMonthJvmKt.access$getIsoFormat().format(this.value);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof YearMonth && Intrinsics.areEqual(this.value, ((YearMonth)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("sh.sit.plp.kotlin_shadedx.datetime.YearMonth must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(11, this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/YearMonth$Companion;", "", "<init>", "()V", "parse", "Lsh/sit/plp/kotlin_shadedx/datetime/YearMonth;", "input", "", "format", "Lsh/sit/plp/kotlin_shadedx/datetime/format/DateTimeFormat;", "Format", "block", "Lsh/sit/plp/kotlin_shaded/Function1;", "Lsh/sit/plp/kotlin_shadedx/datetime/format/DateTimeFormatBuilder$WithYearMonth;", "", "Lsh/sit/plp/kotlin_shaded/ExtensionFunctionType;", "serialVersionUID", "", "serializer", "Lsh/sit/plp/kotlin_shadedx/serialization/KSerializer;", "sh.sit.plp.kotlin_shadedx-datetime"})
    @SourceDebugExtension(value={"SMAP\nYearMonthJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YearMonthJvm.kt\nkotlinx/datetime/YearMonth$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final YearMonth parse(@NotNull CharSequence input, @NotNull DateTimeFormat<YearMonth> format) {
            YearMonth yearMonth;
            Intrinsics.checkNotNullParameter(input, "input");
            Intrinsics.checkNotNullParameter(format, "format");
            if (format == Formats.INSTANCE.getISO()) {
                YearMonth yearMonth2;
                try {
                    String sanitizedInput = UtilKt.removeLeadingZerosFromLongYearFormYearMonth(((Object)input).toString());
                    java.time.YearMonth p0 = java.time.YearMonth.parse(sanitizedInput);
                    boolean bl = false;
                    yearMonth2 = new YearMonth(p0);
                }
                catch (DateTimeParseException e) {
                    throw new DateTimeFormatException(e);
                }
                yearMonth = yearMonth2;
            } else {
                yearMonth = format.parse(input);
            }
            return yearMonth;
        }

        public static /* synthetic */ YearMonth parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = Formats.INSTANCE.getISO();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        @NotNull
        public final DateTimeFormat<YearMonth> Format(@NotNull Function1<? super DateTimeFormatBuilder.WithYearMonth, Unit> block) {
            Intrinsics.checkNotNullParameter(block, "block");
            return YearMonthFormat.Companion.build(block);
        }

        @NotNull
        public final KSerializer<YearMonth> serializer() {
            return YearMonthSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/YearMonth$Formats;", "", "<init>", "()V", "ISO", "Lsh/sit/plp/kotlin_shadedx/datetime/format/DateTimeFormat;", "Lsh/sit/plp/kotlin_shadedx/datetime/YearMonth;", "getISO", "()Lsh/sit/plp/kotlin_shadedx/datetime/format/DateTimeFormat;", "sh.sit.plp.kotlin_shadedx-datetime"})
    public static final class Formats {
        @NotNull
        public static final Formats INSTANCE = new Formats();

        private Formats() {
        }

        @NotNull
        public final DateTimeFormat<YearMonth> getISO() {
            return YearMonthFormatKt.getISO_YEAR_MONTH();
        }
    }
}

