/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.ktoml_shaded.parsers;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.Unit;
import sh.sit.plp.kotlin_shaded.collections.CollectionsKt;
import sh.sit.plp.kotlin_shaded.jvm.internal.DefaultConstructorMarker;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shaded.text.CharsKt;
import sh.sit.plp.kotlin_shaded.text.StringsKt;
import sh.sit.plp.ktoml_shaded.TomlInputConfig;
import sh.sit.plp.ktoml_shaded.exceptions.ParseException;
import sh.sit.plp.ktoml_shaded.parsers.StringUtilsKt;
import sh.sit.plp.ktoml_shaded.parsers.enums.MultilineType;
import sh.sit.plp.ktoml_shaded.utils.LinesIteratorWrapper;
import sh.sit.plp.ktoml_shaded.utils.UtilsJvmKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\b\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0006J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001f\u0010#\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006("}, d2={"Lsh/sit/plp/ktoml_shaded/parsers/TomlMultilineString;", "", "config", "Lsh/sit/plp/ktoml_shaded/TomlInputConfig;", "linesIteratorWrapper", "Lsh/sit/plp/ktoml_shaded/utils/LinesIteratorWrapper;", "", "firstLine", "<init>", "(Lsh/sit/plp/ktoml_shaded/TomlInputConfig;Lsh/sit/plp/ktoml_shaded/utils/LinesIteratorWrapper;Ljava/lang/String;)V", "comments", "", "lines", "startLineNo", "", "multilineType", "Lsh/sit/plp/ktoml_shaded/parsers/enums/MultilineType;", "isInMultilineBasic", "", "isInMultilineLiteral", "isNested", "Ljava/lang/Boolean;", "getLine", "getComments", "", "parseMultiline", "", "trackMultilineString", "line", "isNextThreeQuotes", "index", "quote", "", "isInMultilineString", "isEndOfMultilineValue", "hasTwoConsecutiveSymbolsIgnoreWhitespaces", "value", "searchSymbol", "(Ljava/lang/String;C)Ljava/lang/Boolean;", "Companion", "ktoml-core"})
@SourceDebugExtension(value={"SMAP\nTomlMultilineString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlMultilineString.kt\ncom/akuleshov7/ktoml/parsers/TomlMultilineString\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,208:1\n434#2:209\n507#2,5:210\n1069#2,2:215\n1088#2,2:217\n*S KotlinDebug\n*F\n+ 1 TomlMultilineString.kt\ncom/akuleshov7/ktoml/parsers/TomlMultilineString\n*L\n123#1:209\n123#1:210,5\n157#1:215,2\n160#1:217,2\n*E\n"})
public final class TomlMultilineString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TomlInputConfig config;
    @NotNull
    private final LinesIteratorWrapper<String> linesIteratorWrapper;
    @NotNull
    private final List<String> comments;
    @NotNull
    private final List<String> lines;
    private final int startLineNo;
    @NotNull
    private final MultilineType multilineType;
    private boolean isInMultilineBasic;
    private boolean isInMultilineLiteral;
    @Nullable
    private Boolean isNested;
    @NotNull
    private static final List<MultilineType> stringTypes;

    public TomlMultilineString(@NotNull TomlInputConfig config, @NotNull LinesIteratorWrapper<String> linesIteratorWrapper, @NotNull String firstLine) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(linesIteratorWrapper, "linesIteratorWrapper");
        Intrinsics.checkNotNullParameter(firstLine, "firstLine");
        this.config = config;
        this.linesIteratorWrapper = linesIteratorWrapper;
        this.comments = new ArrayList();
        this.lines = new ArrayList();
        this.startLineNo = this.linesIteratorWrapper.getLineNo$ktoml_core();
        this.multilineType = Companion.getMultilineType(firstLine, this.config);
        this.isNested = this.multilineType.isNestedSupported() ? null : Boolean.valueOf(false);
        if (this.multilineType == MultilineType.NOT_A_MULTILINE) {
            throw new ParseException("Internal parse exception", this.startLineNo);
        }
        this.trackMultilineString(firstLine);
        this.lines.add(StringUtilsKt.takeBeforeComment(firstLine, this.config.getAllowEscapedQuotesInLiteralStrings()));
        this.parseMultiline();
    }

    @NotNull
    public final String getLine() {
        return this.multilineType == MultilineType.ARRAY ? CollectionsKt.joinToString$default(this.lines, String.valueOf(UtilsJvmKt.newLineChar()), null, null, 0, null, arg_0 -> TomlMultilineString.getLine$lambda$0(this, arg_0), 30, null) : CollectionsKt.joinToString$default(this.lines, String.valueOf(UtilsJvmKt.newLineChar()), null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final List<String> getComments() {
        return this.comments;
    }

    private final void parseMultiline() {
        boolean hasFoundEnd = false;
        while (this.linesIteratorWrapper.hasNext()) {
            boolean bl;
            String line = this.linesIteratorWrapper.next();
            this.trackMultilineString(line);
            if (!stringTypes.contains((Object)this.multilineType)) {
                if (!this.isInMultilineString()) {
                    this.comments.add(StringUtilsKt.trimComment(line, this.config.getAllowEscapedQuotesInLiteralStrings()));
                    bl = this.lines.add(StringUtilsKt.takeBeforeComment(line, this.config.getAllowEscapedQuotesInLiteralStrings()));
                } else {
                    bl = this.lines.add(line);
                }
            } else {
                bl = this.lines.add(line);
            }
            if (this.isInMultilineString() || !this.isEndOfMultilineValue(this.multilineType)) continue;
            hasFoundEnd = true;
            break;
        }
        if (!hasFoundEnd) {
            throw new ParseException("Expected (" + this.multilineType.getClosingSymbols() + ") in the end of " + this.multilineType.name(), this.startLineNo);
        }
    }

    private final void trackMultilineString(String line) {
        if (stringTypes.contains((Object)this.multilineType)) {
            return;
        }
        int i = 0;
        int n = line.length() - 3;
        if (i <= n) {
            while (this.isInMultilineBasic || this.isInMultilineLiteral || line.charAt(i) != '#') {
                if (!this.isInMultilineLiteral && this.isNextThreeQuotes(line, i, '\"')) {
                    this.isInMultilineBasic = !this.isInMultilineBasic;
                } else if (!this.isInMultilineBasic && this.isNextThreeQuotes(line, i, '\'')) {
                    boolean bl = this.isInMultilineLiteral = !this.isInMultilineLiteral;
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    private final boolean isNextThreeQuotes(String line, int index, char quote) {
        return line.charAt(index) == quote && line.charAt(index + 1) == quote && line.charAt(index + 2) == quote;
    }

    private final boolean isInMultilineString() {
        return this.isInMultilineBasic || this.isInMultilineLiteral;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEndOfMultilineValue(MultilineType multilineType) {
        boolean bl;
        Object object = this.isNested;
        if (object == null) {
            TomlMultilineString $this$isEndOfMultilineValue_u24lambda_u241 = this;
            boolean bl2 = false;
            $this$isEndOfMultilineValue_u24lambda_u241.isNested = $this$isEndOfMultilineValue_u24lambda_u241.hasTwoConsecutiveSymbolsIgnoreWhitespaces($this$isEndOfMultilineValue_u24lambda_u241.getLine(), multilineType.getOpenSymbols().charAt(0));
            object = Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(this.isNested, true)) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = CollectionsKt.joinToString$default(this.lines, "", null, null, 0, null, null, 62, null);
            boolean $i$f$filter = false;
            CharSequence bl2 = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl3 = false;
                if (!(!CharsKt.isWhitespace(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String clearedString = ((StringBuilder)destination$iv$iv).toString();
            bl = multilineType == MultilineType.ARRAY ? StringsKt.endsWith$default(clearedString, multilineType.getClosingSymbols() + multilineType.getClosingSymbols(), false, 2, null) || StringsKt.endsWith$default(clearedString, multilineType.getClosingSymbols() + ',' + multilineType.getClosingSymbols(), false, 2, null) : StringsKt.endsWith$default(clearedString, multilineType.getClosingSymbols() + multilineType.getClosingSymbols(), false, 2, null);
        } else {
            int closingSymbolsIdx = StringsKt.lastIndexOf$default((CharSequence)CollectionsKt.last(this.lines), multilineType.getClosingSymbols(), 0, false, 6, null);
            if (closingSymbolsIdx < 0) {
                return false;
            }
            String string = CollectionsKt.last(this.lines).substring(closingSymbolsIdx + multilineType.getClosingSymbols().length());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            bl = ((CharSequence)((Object)StringsKt.trim((CharSequence)StringUtilsKt.takeBeforeComment(string, this.config.getAllowEscapedQuotesInLiteralStrings()))).toString()).length() == 0;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean hasTwoConsecutiveSymbolsIgnoreWhitespaces(String value, char searchSymbol) {
        boolean bl;
        block5: {
            void $this$any$iv;
            int firstIndex = StringsKt.indexOf$default((CharSequence)value, searchSymbol, 0, false, 6, null);
            if (firstIndex == -1) {
                return false;
            }
            int nextIndex = StringsKt.indexOf$default((CharSequence)value, searchSymbol, firstIndex + 1, false, 4, null);
            if (nextIndex != -1) {
                boolean bl2;
                block4: {
                    String string = value.substring(firstIndex + 1, nextIndex);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    String between = string;
                    CharSequence $this$all$iv = between;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl3 = false;
                        if (CharsKt.isWhitespace(it)) continue;
                        bl2 = false;
                        break block4;
                    }
                    bl2 = true;
                }
                return bl2;
            }
            String string = value.substring(firstIndex + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            CharSequence $this$all$iv = string;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl4 = false;
                if (!(!CharsKt.isWhitespace(it))) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        boolean isRestHasOnlyWhitespaces = !bl;
        return isRestHasOnlyWhitespaces ? null : Boolean.valueOf(false);
    }

    private static final CharSequence getLine$lambda$0(TomlMultilineString this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringUtilsKt.takeBeforeComment(it, this$0.config.getAllowEscapedQuotesInLiteralStrings());
    }

    static {
        MultilineType[] multilineTypeArray = new MultilineType[]{MultilineType.BASIC_STRING, MultilineType.LITERAL_STRING};
        stringTypes = CollectionsKt.listOf(multilineTypeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lsh/sit/plp/ktoml_shaded/parsers/TomlMultilineString$Companion;", "", "<init>", "()V", "stringTypes", "", "Lsh/sit/plp/ktoml_shaded/parsers/enums/MultilineType;", "getMultilineType", "line", "", "config", "Lsh/sit/plp/ktoml_shaded/TomlInputConfig;", "ktoml-core"})
    @SourceDebugExtension(value={"SMAP\nTomlMultilineString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlMultilineString.kt\ncom/akuleshov7/ktoml/parsers/TomlMultilineString$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,208:1\n158#2,6:209\n*S KotlinDebug\n*F\n+ 1 TomlMultilineString.kt\ncom/akuleshov7/ktoml/parsers/TomlMultilineString$Companion\n*L\n180#1:209,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultilineType getMultilineType(@NotNull String line, @NotNull TomlInputConfig config) {
            int firstEqualsSign;
            String line2;
            block5: {
                int n;
                Intrinsics.checkNotNullParameter(line, "line");
                Intrinsics.checkNotNullParameter(config, "config");
                line2 = StringUtilsKt.takeBeforeComment(line, config.getAllowEscapedQuotesInLiteralStrings());
                CharSequence $this$indexOfFirst$iv = line2;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '=')) continue;
                    n = index$iv;
                    break block5;
                }
                n = firstEqualsSign = -1;
            }
            if (firstEqualsSign == -1) {
                return MultilineType.NOT_A_MULTILINE;
            }
            String string = line2.substring(firstEqualsSign + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (StringsKt.startsWith$default(value, MultilineType.ARRAY.getOpenSymbols(), false, 2, null) && !StringsKt.endsWith$default(value, MultilineType.ARRAY.getClosingSymbols(), false, 2, null)) {
                return MultilineType.ARRAY;
            }
            if (StringsKt.startsWith$default(value, MultilineType.BASIC_STRING.getOpenSymbols(), false, 2, null) && StringUtilsKt.getCountOfOccurrencesOfSubstring(value, MultilineType.BASIC_STRING.getOpenSymbols()) == 1) {
                return MultilineType.BASIC_STRING;
            }
            if (StringsKt.startsWith$default(value, MultilineType.LITERAL_STRING.getOpenSymbols(), false, 2, null) && StringUtilsKt.getCountOfOccurrencesOfSubstring(value, MultilineType.LITERAL_STRING.getOpenSymbols()) == 1) {
                return MultilineType.LITERAL_STRING;
            }
            return MultilineType.NOT_A_MULTILINE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

