/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.ktoml_shaded.utils;

import org.jetbrains.annotations.NotNull;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.Unit;
import sh.sit.plp.kotlin_shaded.jvm.functions.Function1;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shaded.text.CharCategory;
import sh.sit.plp.kotlin_shaded.text.CharsKt;
import sh.sit.plp.kotlin_shaded.text.StringsKt;
import sh.sit.plp.ktoml_shaded.exceptions.UnknownEscapeSymbolsException;
import sh.sit.plp.ktoml_shaded.utils.UtilsJvmKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a.\u0010\f\u001a\u00020\u0001*\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0014\u0010\u0012\u001a\u00020\n*\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0003H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0014*\u00020\u0003H\u0000\u001a!\u0010\u0017\u001a\u00020\n*\u00020\n2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0019H\u0082\b\u001a\f\u0010\u001a\u001a\u00020\n*\u00020\u0003H\u0002\u001a\u0014\u0010\u001b\u001a\u00020\n*\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"COMPLEX_UNICODE_LENGTH", "", "COMPLEX_UNICODE_PREFIX", "", "BIN_RADIX", "OCT_RADIX", "HEX_RADIX", "SIMPLE_UNICODE_LENGTH", "SIMPLE_UNICODE_PREFIX", "convertSpecialCharacters", "", "lineNo", "appendEscapedUnicode", "Ljava/lang/StringBuilder;", "Lsh/sit/plp/kotlin_shaded/text/StringBuilder;", "fullString", "marker", "codeStartIndex", "escapeSpecialCharacters", "multiline", "", "isControlChar", "isMultilineControlChar", "escapeControlChars", "predicate", "Lsh/sit/plp/kotlin_shaded/Function1;", "escapeControlChar", "escapeBackslashes", "escapes", "ktoml-core"})
@SourceDebugExtension(value={"SMAP\nSpecialCharacters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialCharacters.kt\ncom/akuleshov7/ktoml/utils/SpecialCharactersKt\n*L\n1#1,200:1\n137#1,15:201\n137#1,15:216\n*S KotlinDebug\n*F\n+ 1 SpecialCharacters.kt\ncom/akuleshov7/ktoml/utils/SpecialCharactersKt\n*L\n106#1:201,15\n110#1:216,15\n*E\n"})
public final class SpecialCharactersKt {
    public static final int COMPLEX_UNICODE_LENGTH = 8;
    public static final char COMPLEX_UNICODE_PREFIX = 'U';
    public static final int BIN_RADIX = 2;
    public static final int OCT_RADIX = 8;
    public static final int HEX_RADIX = 16;
    public static final int SIMPLE_UNICODE_LENGTH = 4;
    public static final char SIMPLE_UNICODE_PREFIX = 'u';

    @NotNull
    public static final String convertSpecialCharacters(@NotNull String $this$convertSpecialCharacters, int lineNo) {
        int offset;
        Intrinsics.checkNotNullParameter($this$convertSpecialCharacters, "<this>");
        StringBuilder resultString = new StringBuilder();
        block11: for (int i = 0; i < $this$convertSpecialCharacters.length(); i += offset) {
            Object object;
            char currentChar = $this$convertSpecialCharacters.charAt(i);
            offset = 1;
            if (currentChar == '\\' && i != StringsKt.getLastIndex($this$convertSpecialCharacters)) {
                char next = $this$convertSpecialCharacters.charAt(i + 1);
                ++offset;
                switch (next) {
                    case 't': {
                        object = resultString.append('\t');
                        continue block11;
                    }
                    case 'b': {
                        object = resultString.append('\b');
                        continue block11;
                    }
                    case 'r': {
                        object = resultString.append('\r');
                        continue block11;
                    }
                    case 'n': {
                        object = resultString.append('\n');
                        continue block11;
                    }
                    case 'f': {
                        object = resultString.append('\f');
                        continue block11;
                    }
                    case '\\': {
                        object = resultString.append('\\');
                        continue block11;
                    }
                    case '\'': {
                        object = resultString.append('\'');
                        continue block11;
                    }
                    case '\"': {
                        object = resultString.append('\"');
                        continue block11;
                    }
                    case 'U': 
                    case 'u': {
                        offset += SpecialCharactersKt.appendEscapedUnicode(resultString, $this$convertSpecialCharacters, next, i + 2, lineNo);
                        object = Unit.INSTANCE;
                        continue block11;
                    }
                    default: {
                        throw new UnknownEscapeSymbolsException("" + '\\' + next, lineNo);
                    }
                }
            }
            object = resultString.append(currentChar);
        }
        String string = resultString.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static final int appendEscapedUnicode(@NotNull StringBuilder $this$appendEscapedUnicode, @NotNull String fullString, char marker, int codeStartIndex, int lineNo) {
        int nbUnicodeChars;
        Intrinsics.checkNotNullParameter($this$appendEscapedUnicode, "<this>");
        Intrinsics.checkNotNullParameter(fullString, "fullString");
        int n = nbUnicodeChars = marker == 'u' ? 4 : 8;
        if (codeStartIndex + nbUnicodeChars > fullString.length()) {
            String string = fullString.substring(codeStartIndex - 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String invalid = string;
            throw new UnknownEscapeSymbolsException('\\' + invalid, lineNo);
        }
        String string = fullString.substring(codeStartIndex, codeStartIndex + nbUnicodeChars);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String hexCode = string;
        int codePoint = Integer.parseInt(hexCode, CharsKt.checkRadix(16));
        try {
            UtilsJvmKt.appendCodePointCompat($this$appendEscapedUnicode, codePoint);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownEscapeSymbolsException("" + '\\' + marker + hexCode, lineNo);
        }
        return nbUnicodeChars;
    }

    @NotNull
    public static final String escapeSpecialCharacters(@NotNull String $this$escapeSpecialCharacters, boolean multiline) {
        String string;
        Intrinsics.checkNotNullParameter($this$escapeSpecialCharacters, "<this>");
        if (multiline) {
            String $this$escapeControlChars$iv = $this$escapeSpecialCharacters;
            boolean $i$f$escapeControlChars = false;
            StringBuilder sb$iv = new StringBuilder($this$escapeControlChars$iv.length());
            int last$iv = 0;
            int n = $this$escapeControlChars$iv.length();
            for (int i = 0; i < n; ++i) {
                char char$iv;
                int i$iv = i;
                char p0 = char$iv = $this$escapeControlChars$iv.charAt(i);
                boolean bl = false;
                if (!SpecialCharactersKt.isMultilineControlChar(p0)) continue;
                sb$iv.append($this$escapeControlChars$iv, last$iv, i$iv).append(SpecialCharactersKt.escapeControlChar(char$iv));
                last$iv = i$iv + 1;
            }
            if (last$iv < $this$escapeControlChars$iv.length()) {
                sb$iv.append($this$escapeControlChars$iv, last$iv, $this$escapeControlChars$iv.length());
            }
            String string2 = sb$iv.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            string = SpecialCharactersKt.escapeBackslashes(StringsKt.replace$default(string2, "\"\"\"", "\"\"\\\"", false, 4, null), "btnfruU\"\r\n");
        } else {
            String $this$escapeControlChars$iv = $this$escapeSpecialCharacters;
            boolean $i$f$escapeControlChars = false;
            StringBuilder sb$iv = new StringBuilder($this$escapeControlChars$iv.length());
            int last$iv = 0;
            int n = $this$escapeControlChars$iv.length();
            for (int i = 0; i < n; ++i) {
                char char$iv;
                int i$iv = i;
                char p0 = char$iv = $this$escapeControlChars$iv.charAt(i);
                boolean bl = false;
                if (!SpecialCharactersKt.isControlChar(p0)) continue;
                sb$iv.append($this$escapeControlChars$iv, last$iv, i$iv).append(SpecialCharactersKt.escapeControlChar(char$iv));
                last$iv = i$iv + 1;
            }
            if (last$iv < $this$escapeControlChars$iv.length()) {
                sb$iv.append($this$escapeControlChars$iv, last$iv, $this$escapeControlChars$iv.length());
            }
            String string3 = sb$iv.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            string = SpecialCharactersKt.escapeBackslashes(StringsKt.replace$default(string3, "\"", "\\\"", false, 4, null), "btnfruU\"");
        }
        return string;
    }

    public static /* synthetic */ String escapeSpecialCharacters$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialCharactersKt.escapeSpecialCharacters(string, bl);
    }

    public static final boolean isControlChar(char $this$isControlChar) {
        return CharCategory.CONTROL.contains($this$isControlChar) && $this$isControlChar != '\t';
    }

    public static final boolean isMultilineControlChar(char $this$isMultilineControlChar) {
        return SpecialCharactersKt.isControlChar($this$isMultilineControlChar) && !StringsKt.contains$default((CharSequence)"\n\r", $this$isMultilineControlChar, false, 2, null);
    }

    private static final String escapeControlChars(String $this$escapeControlChars, Function1<? super Character, Boolean> predicate) {
        boolean $i$f$escapeControlChars = false;
        StringBuilder sb = new StringBuilder($this$escapeControlChars.length());
        int last = 0;
        int n = $this$escapeControlChars.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            char c = $this$escapeControlChars.charAt(i);
            if (!predicate.invoke(Character.valueOf(c)).booleanValue()) continue;
            sb.append($this$escapeControlChars, last, i2).append(SpecialCharactersKt.escapeControlChar(c));
            last = i2 + 1;
        }
        if (last < $this$escapeControlChars.length()) {
            sb.append($this$escapeControlChars, last, $this$escapeControlChars.length());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String escapeControlChar(char $this$escapeControlChar) {
        String string;
        switch ($this$escapeControlChar) {
            case '\t': {
                string = "\\t";
                break;
            }
            case '\b': {
                string = "\\b";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\f': {
                string = "\\f";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            default: {
                String string2 = Integer.toString($this$escapeControlChar, CharsKt.checkRadix(16));
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                String hexDigits = string2;
                string = "\\u" + StringsKt.padStart(hexDigits, 4, '0');
            }
        }
        return string;
    }

    private static final String escapeBackslashes(String $this$escapeBackslashes, String escapes) {
        StringBuilder sb = new StringBuilder($this$escapeBackslashes.length());
        int slashCount = 0;
        int last = 0;
        int n = $this$escapeBackslashes.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            char c = $this$escapeBackslashes.charAt(i);
            if (c == '\\') {
                ++slashCount;
                continue;
            }
            if (slashCount > 0 && !StringsKt.contains$default((CharSequence)escapes, c, false, 2, null) && slashCount % 2 != 0) {
                sb.append($this$escapeBackslashes, last, i2 - 1).append("\\\\" + c);
                last = i2 + 1;
            }
            slashCount = 0;
        }
        if (last < $this$escapeBackslashes.length()) {
            sb.append($this$escapeBackslashes, last, $this$escapeBackslashes.length());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

