/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import sh.sit.plp.PlayerLocatorPlus;
import sh.sit.plp.color.PlayerDataState;
import sh.sit.plp.config.ModConfig;
import sh.sit.plp.network.PlayerLocationsS2CPayload;
import sh.sit.plp.network.RelativePlayerLocation;
import sh.sit.plp.util.ColorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\tJ#\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\fR\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lsh/sit/plp/BarUpdater;", "", "<init>", "()V", "", "reset", "Lnet/minecraft/server/MinecraftServer;", "server", "fullResend", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_3222;", "player", "(Lnet/minecraft/class_3222;)V", "update", "", "Ljava/util/UUID;", "Lsh/sit/plp/BarUpdater$StoredPlayerPosition;", "getPositions", "(Lnet/minecraft/server/MinecraftServer;)Ljava/util/Map;", "uuid", "selfPos", "otherPos", "Lsh/sit/plp/network/RelativePlayerLocation;", "calculateRelativeLocation", "(Ljava/util/UUID;Lsh/sit/plp/BarUpdater$StoredPlayerPosition;Lsh/sit/plp/BarUpdater$StoredPlayerPosition;)Lsh/sit/plp/network/RelativePlayerLocation;", "sendFakePlayers", "previousPositions", "Ljava/util/Map;", "StoredPlayerPosition", "player-locator-plus"})
@SourceDebugExtension(value={"SMAP\nBarUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarUpdater.kt\nsh/sit/plp/BarUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1863#2,2:227\n1611#2,9:229\n1863#2:238\n1864#2:240\n1620#2:241\n827#2:242\n855#2,2:243\n1187#2,2:245\n1261#2,4:247\n1557#2:251\n1628#2,3:252\n1#3:239\n*S KotlinDebug\n*F\n+ 1 BarUpdater.kt\nsh/sit/plp/BarUpdater\n*L\n49#1:227,2\n57#1:229,9\n57#1:238\n57#1:240\n57#1:241\n175#1:242\n175#1:243,2\n182#1:245,2\n182#1:247,4\n207#1:251\n207#1:252,3\n57#1:239\n*E\n"})
public final class BarUpdater {
    @NotNull
    public static final BarUpdater INSTANCE = new BarUpdater();
    @NotNull
    private static Map<UUID, StoredPlayerPosition> previousPositions = MapsKt.emptyMap();

    private BarUpdater() {
    }

    public final void reset() {
        previousPositions = MapsKt.emptyMap();
    }

    public final void fullResend(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 it = (class_3222)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.fullResend(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fullResend(@NotNull class_3222 player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List playerList = player.method_51469().method_18456();
        Intrinsics.checkNotNull((Object)playerList);
        Iterable $this$mapNotNull$iv = playerList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RelativePlayerLocation relativePlayerLocation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it, (Object)player)) {
                relativePlayerLocation = null;
            } else {
                float distance = (float)player.method_19538().method_1022(it.method_19538());
                if (PlayerLocatorPlus.INSTANCE.getConfig().getMaxDistance() != 0 && distance > (float)PlayerLocatorPlus.INSTANCE.getConfig().getMaxDistance()) {
                    relativePlayerLocation = null;
                } else {
                    UUID uUID = it.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
                    StoredPlayerPosition storedPlayerPosition = new StoredPlayerPosition(player);
                    Intrinsics.checkNotNull((Object)it);
                    relativePlayerLocation = INSTANCE.calculateRelativeLocation(uUID, storedPlayerPosition, new StoredPlayerPosition(it));
                }
            }
            if (relativePlayerLocation == null) continue;
            RelativePlayerLocation it$iv$iv = relativePlayerLocation;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List relativePositions = (List)destination$iv$iv;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new PlayerLocationsS2CPayload(PlayerLocatorPlus.INSTANCE.getConfig().getEnabled() ? relativePositions : CollectionsKt.emptyList(), CollectionsKt.emptyList(), true));
    }

    public final void update(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!PlayerLocatorPlus.INSTANCE.getConfig().getEnabled()) {
            return;
        }
        Map<UUID, StoredPlayerPosition> currentPositions = this.getPositions(server);
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean bl;
            double currentDistance;
            StoredPlayerPosition curPos;
            StoredPlayerPosition previousPlayer = previousPositions.get(player.method_5667());
            int maxDistance = PlayerLocatorPlus.INSTANCE.getConfig().getMaxDistance();
            Set removeUuids = new LinkedHashSet();
            for (Map.Entry<UUID, StoredPlayerPosition> object2 : previousPositions.entrySet()) {
                UUID uuid = object2.getKey();
                StoredPlayerPosition prevPos = object2.getValue();
                if (Intrinsics.areEqual((Object)uuid, (Object)player.method_5667())) continue;
                curPos = currentPositions.get(uuid);
                StoredPlayerPosition storedPlayerPosition = curPos;
                if (!Intrinsics.areEqual((Object)prevPos.getWorld(), (Object)(storedPlayerPosition != null ? storedPlayerPosition.getWorld() : null)) && Intrinsics.areEqual((Object)player.method_37908(), (Object)prevPos.getWorld())) {
                    removeUuids.add(uuid);
                }
                StoredPlayerPosition storedPlayerPosition2 = previousPlayer;
                if (!Intrinsics.areEqual((Object)(storedPlayerPosition2 != null ? storedPlayerPosition2.getWorld() : null), (Object)player.method_37908())) {
                    StoredPlayerPosition storedPlayerPosition3 = previousPlayer;
                    StoredPlayerPosition storedPlayerPosition4 = curPos;
                    if (Intrinsics.areEqual((Object)(storedPlayerPosition3 != null ? storedPlayerPosition3.getWorld() : null), (Object)(storedPlayerPosition4 != null ? storedPlayerPosition4.getWorld() : null))) {
                        removeUuids.add(uuid);
                    }
                }
                if (curPos == null || previousPlayer == null || !Intrinsics.areEqual((Object)curPos.getWorld(), (Object)player.method_37908()) || !Intrinsics.areEqual((Object)curPos.getWorld(), (Object)prevPos.getWorld()) || maxDistance == 0) continue;
                double previousDistance = previousPlayer.getPos().method_1022(prevPos.getPos());
                currentDistance = player.method_19538().method_1022(curPos.getPos());
                if (!(currentDistance > (double)maxDistance) || !(previousDistance <= (double)maxDistance)) continue;
                removeUuids.add(uuid);
            }
            List updatedPositions = new ArrayList();
            for (Map.Entry<UUID, StoredPlayerPosition> entry : currentPositions.entrySet()) {
                RelativePlayerLocation relativePlayerLocation;
                UUID uuid = entry.getKey();
                curPos = entry.getValue();
                if (Intrinsics.areEqual((Object)uuid, (Object)player.method_5667()) || !Intrinsics.areEqual((Object)curPos.getWorld(), (Object)player.method_37908())) continue;
                if (previousPositions.get(uuid) != null) {
                    boolean bl2 = false;
                    if (previousPlayer != null) {
                        StoredPlayerPosition prevPos;
                        StoredPlayerPosition prevPlayer;
                        boolean bl22 = false;
                        relativePlayerLocation = INSTANCE.calculateRelativeLocation(uuid, prevPlayer, prevPos);
                    } else {
                        relativePlayerLocation = null;
                    }
                } else {
                    relativePlayerLocation = null;
                }
                RelativePlayerLocation previousRelativeLocation = relativePlayerLocation;
                Intrinsics.checkNotNull((Object)player);
                RelativePlayerLocation currentRelativeLocation = this.calculateRelativeLocation(uuid, new StoredPlayerPosition(player), curPos);
                if (Intrinsics.areEqual((Object)previousRelativeLocation, (Object)currentRelativeLocation)) continue;
                currentDistance = player.method_19538().method_1022(curPos.getPos());
                if (maxDistance != 0 && currentDistance > (double)maxDistance) continue;
                updatedPositions.add(currentRelativeLocation);
            }
            StoredPlayerPosition storedPlayerPosition = previousPlayer;
            boolean bl3 = bl = !Intrinsics.areEqual((Object)(storedPlayerPosition != null ? storedPlayerPosition.getWorld() : null), (Object)player.method_37908());
            if (updatedPositions.isEmpty() && removeUuids.isEmpty()) continue;
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PlayerLocationsS2CPayload(updatedPositions, CollectionsKt.toList((Iterable)removeUuids), bl));
        }
        previousPositions = currentPositions;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UUID, StoredPlayerPosition> getPositions(MinecraftServer server) {
        void $this$associateTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl = false;
            if (PlayerLocatorPlus.INSTANCE.getConfig().getSneakingHides() && it.method_5715() || PlayerLocatorPlus.INSTANCE.getConfig().getPumpkinHides() && ((class_1799)it.method_31548().field_7548.get(3)).method_31574(class_2246.field_10147.method_8389()) || PlayerLocatorPlus.INSTANCE.getConfig().getMobHeadsHide() && it.method_6118(class_1304.field_6169).method_31573(PlayerLocatorPlus.INSTANCE.getHIDING_EQUIPMENT_TAG()) || PlayerLocatorPlus.INSTANCE.getConfig().getInvisibilityHides() && it.method_6059(class_1294.field_5905) || it.method_7325()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl = false;
            UUID uUID = it.method_5667();
            Intrinsics.checkNotNull((Object)it);
            Pair pair = TuplesKt.to((Object)uUID, (Object)new StoredPlayerPosition(it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final RelativePlayerLocation calculateRelativeLocation(UUID uuid, StoredPlayerPosition selfPos, StoredPlayerPosition otherPos) {
        float distance;
        Vector3f direction = selfPos.getPos().method_1035(otherPos.getPos()).method_1029().method_46409();
        direction.x = (float)Math.rint(direction.x * PlayerLocatorPlus.INSTANCE.getConfig().getDirectionPrecision()) / PlayerLocatorPlus.INSTANCE.getConfig().getDirectionPrecision();
        direction.y = (float)Math.rint(direction.y * PlayerLocatorPlus.INSTANCE.getConfig().getDirectionPrecision()) / PlayerLocatorPlus.INSTANCE.getConfig().getDirectionPrecision();
        direction.z = (float)Math.rint(direction.z * PlayerLocatorPlus.INSTANCE.getConfig().getDirectionPrecision()) / PlayerLocatorPlus.INSTANCE.getConfig().getDirectionPrecision();
        Intrinsics.checkNotNull((Object)direction);
        return new RelativePlayerLocation(uuid, direction, PlayerLocatorPlus.INSTANCE.getConfig().getSendDistance() ? ((distance = (float)selfPos.getPos().method_1022(otherPos.getPos())) < 200.0f ? distance : (float)Math.rint(distance / (float)50) * (float)50) : 0.0f, otherPos.getColor());
    }

    /*
     * WARNING - void declaration
     */
    public final void sendFakePlayers(@NotNull class_3222 player) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$map$iv = (Iterable)new IntRange(0, 5);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            Vector3f vector3f = new Vector3f(Random.Default.nextFloat(), Random.Default.nextFloat() * 0.75f, Random.Default.nextFloat());
            float f = PlayerLocatorPlus.INSTANCE.getConfig().getSendDistance() ? Random.Default.nextFloat() * 750.0f : 0.0f;
            UUID uUID2 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
            collection.add(new RelativePlayerLocation(uUID, vector3f, f, ColorUtils.INSTANCE.uuidToColor(uUID2)));
        }
        List positions = (List)destination$iv$iv;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new PlayerLocationsS2CPayload(positions, CollectionsKt.emptyList(), false));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J.\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0012J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010\u0012\u00a8\u0006$"}, d2={"Lsh/sit/plp/BarUpdater$StoredPlayerPosition;", "", "Lnet/minecraft/class_243;", "pos", "Lnet/minecraft/class_1937;", "world", "", "color", "<init>", "(Lnet/minecraft/class_243;Lnet/minecraft/class_1937;I)V", "Lnet/minecraft/class_3222;", "player", "(Lnet/minecraft/class_3222;)V", "component1", "()Lnet/minecraft/class_243;", "component2", "()Lnet/minecraft/class_1937;", "component3", "()I", "copy", "(Lnet/minecraft/class_243;Lnet/minecraft/class_1937;I)Lsh/sit/plp/BarUpdater$StoredPlayerPosition;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_243;", "getPos", "Lnet/minecraft/class_1937;", "getWorld", "I", "getColor", "Companion", "player-locator-plus"})
    private static final class StoredPlayerPosition {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final class_243 pos;
        @NotNull
        private final class_1937 world;
        private final int color;

        public StoredPlayerPosition(@NotNull class_243 pos, @NotNull class_1937 world, int color) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            this.pos = pos;
            this.world = world;
            this.color = color;
        }

        @NotNull
        public final class_243 getPos() {
            return this.pos;
        }

        @NotNull
        public final class_1937 getWorld() {
            return this.world;
        }

        public final int getColor() {
            return this.color;
        }

        public StoredPlayerPosition(@NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_243 class_2432 = player.method_19538();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
            class_1937 class_19372 = player.method_37908();
            Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"getWorld(...)");
            this(class_2432, class_19372, Companion.calculateColor(player));
        }

        @NotNull
        public final class_243 component1() {
            return this.pos;
        }

        @NotNull
        public final class_1937 component2() {
            return this.world;
        }

        public final int component3() {
            return this.color;
        }

        @NotNull
        public final StoredPlayerPosition copy(@NotNull class_243 pos, @NotNull class_1937 world, int color) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return new StoredPlayerPosition(pos, world, color);
        }

        public static /* synthetic */ StoredPlayerPosition copy$default(StoredPlayerPosition storedPlayerPosition, class_243 class_2432, class_1937 class_19372, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_2432 = storedPlayerPosition.pos;
            }
            if ((n2 & 2) != 0) {
                class_19372 = storedPlayerPosition.world;
            }
            if ((n2 & 4) != 0) {
                n = storedPlayerPosition.color;
            }
            return storedPlayerPosition.copy(class_2432, class_19372, n);
        }

        @NotNull
        public String toString() {
            return "StoredPlayerPosition(pos=" + this.pos + ", world=" + this.world + ", color=" + this.color + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.world.hashCode();
            result = result * 31 + Integer.hashCode(this.color);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StoredPlayerPosition)) {
                return false;
            }
            StoredPlayerPosition storedPlayerPosition = (StoredPlayerPosition)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)storedPlayerPosition.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.world, (Object)storedPlayerPosition.world)) {
                return false;
            }
            return this.color == storedPlayerPosition.color;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsh/sit/plp/BarUpdater$StoredPlayerPosition$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "calculateColor", "(Lnet/minecraft/class_3222;)I", "player-locator-plus"})
        public static final class Companion {
            private Companion() {
            }

            public final int calculateColor(@NotNull class_3222 player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return switch (WhenMappings.$EnumSwitchMapping$0[PlayerLocatorPlus.INSTANCE.getConfig().getColorMode().ordinal()]) {
                    case 1 -> {
                        UUID v0 = player.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getUuid(...)");
                        yield ColorUtils.INSTANCE.uuidToColor(v0);
                    }
                    case 2 -> player.method_22861();
                    case 3 -> PlayerLocatorPlus.INSTANCE.getConfig().getConstantColor();
                    case 4 -> {
                        MinecraftServer v2 = player.field_13995;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"server");
                        PlayerDataState v3 = PlayerDataState.Companion.of(v2);
                        UUID v4 = player.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getUuid(...)");
                        yield v3.getPlayer(v4).getCustomColor();
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ModConfig.ColorMode.values().length];
                    try {
                        nArray[ModConfig.ColorMode.UUID.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ModConfig.ColorMode.TEAM_COLOR.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ModConfig.ColorMode.CONSTANT.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ModConfig.ColorMode.CUSTOM.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

