/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.config;

import com.akuleshov7.ktoml.Toml;
import com.akuleshov7.ktoml.TomlInputConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import org.jetbrains.annotations.NotNull;
import sh.sit.plp.config.ModConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0013R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lsh/sit/plp/config/KTomlConfigSerializer;", "Lme/shedaniel/autoconfig/serializer/ConfigSerializer;", "Lsh/sit/plp/config/ModConfig;", "Lme/shedaniel/autoconfig/annotation/Config;", "definition", "Ljava/lang/Class;", "configClass", "<init>", "(Lme/shedaniel/autoconfig/annotation/Config;Ljava/lang/Class;)V", "Ljava/nio/file/Path;", "getConfigPath", "()Ljava/nio/file/Path;", "config", "", "serialize", "(Lsh/sit/plp/config/ModConfig;)V", "deserialize", "()Lsh/sit/plp/config/ModConfig;", "createDefault", "Lme/shedaniel/autoconfig/annotation/Config;", "Ljava/lang/Class;", "Lcom/akuleshov7/ktoml/Toml;", "toml", "Lcom/akuleshov7/ktoml/Toml;", "player-locator-plus"})
@SourceDebugExtension(value={"SMAP\nKTomlConfigSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KTomlConfigSerializer.kt\nsh/sit/plp/config/KTomlConfigSerializer\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,62:1\n113#2:63\n123#2:64\n*S KotlinDebug\n*F\n+ 1 KTomlConfigSerializer.kt\nsh/sit/plp/config/KTomlConfigSerializer\n*L\n33#1:63\n46#1:64\n*E\n"})
public final class KTomlConfigSerializer
implements ConfigSerializer<ModConfig> {
    @NotNull
    private final Config definition;
    @NotNull
    private final Class<ModConfig> configClass;
    @NotNull
    private final Toml toml;

    public KTomlConfigSerializer(@NotNull Config definition, @NotNull Class<ModConfig> configClass) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        this.definition = definition;
        this.configClass = configClass;
        this.toml = new Toml(new TomlInputConfig(true, false, false, false, false, 30, null), null, null, 6, null);
    }

    private final Path getConfigPath() {
        Path path = Utils.getConfigFolder().resolve(this.definition.name() + ".toml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public void serialize(@NotNull ModConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Path configPath = this.getConfigPath();
        try {
            StringFormat $this$encodeToString$iv = (StringFormat)this.toml;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            String configString = $this$encodeToString$iv.encodeToString((SerializationStrategy)ModConfig.Companion.serializer(), (Object)config);
            File file = configPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.writeText$default((File)file, (String)configString, null, (int)2, null);
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException((Throwable)e);
        }
    }

    @NotNull
    public ModConfig deserialize() {
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                File file = configPath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                String configString = FilesKt.readText$default((File)file, null, (int)1, null);
                StringFormat $this$decodeFromString$iv = (StringFormat)this.toml;
                boolean $i$f$decodeFromString = false;
                $this$decodeFromString$iv.getSerializersModule();
                ModConfig config = (ModConfig)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)ModConfig.Companion.serializer(), configString);
                return config;
            }
            catch (IOException e) {
                throw new ConfigSerializer.SerializationException((Throwable)e);
            }
            catch (SerializationException e) {
                throw new ConfigSerializer.SerializationException((Throwable)e);
            }
        }
        return this.createDefault();
    }

    @NotNull
    public ModConfig createDefault() {
        Object object = Utils.constructUnsafely(this.configClass);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"constructUnsafely(...)");
        return (ModConfig)object;
    }
}

