/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.util;

import kotlin.Metadata;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0005R\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0005R\"\u0010\u000e\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\n\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0005R$\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0013\u0010\fR\u0016\u0010\u0014\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\nR\u0016\u0010\u0015\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\n\u00a8\u0006\u0016"}, d2={"Lsh/sit/plp/util/Animatable;", "", "", "initialValue", "<init>", "(F)V", "timeElapsed", "", "updateValues", "naturalFreq", "F", "getNaturalFreq", "()F", "setNaturalFreq", "targetValue", "getTargetValue", "setTargetValue", "value", "currentValue", "getCurrentValue", "lastDisplacement", "lastVelocity", "player-locator-plus_client"})
@Environment(value=EnvType.CLIENT)
public final class Animatable {
    private float naturalFreq = 120.0f;
    private float targetValue;
    private float currentValue;
    private float lastDisplacement;
    private float lastVelocity;

    public Animatable(float initialValue) {
        this.targetValue = initialValue;
        this.currentValue = initialValue;
    }

    public final float getNaturalFreq() {
        return this.naturalFreq;
    }

    public final void setNaturalFreq(float f) {
        this.naturalFreq = f;
    }

    public final float getTargetValue() {
        return this.targetValue;
    }

    public final void setTargetValue(float f) {
        this.targetValue = f;
    }

    public final float getCurrentValue() {
        return this.currentValue;
    }

    public final void updateValues(float timeElapsed) {
        float adjustedDisplacement = this.lastDisplacement - this.targetValue;
        double deltaT = (double)timeElapsed / 1000.0;
        double displacement = 0.0;
        double currentVelocity = 0.0;
        float coeffA = adjustedDisplacement;
        float coeffB = this.lastVelocity + this.naturalFreq * adjustedDisplacement;
        double nFdT = (double)(-this.naturalFreq) * deltaT;
        displacement = ((double)coeffA + (double)coeffB * deltaT) * Math.exp(nFdT);
        currentVelocity = ((double)coeffA + (double)coeffB * deltaT) * Math.exp(nFdT) * (double)(-this.naturalFreq) + (double)coeffB * Math.exp(nFdT);
        float newValue = (float)(displacement + (double)this.targetValue);
        float newVelocity = (float)currentVelocity;
        this.lastDisplacement = newValue;
        this.lastVelocity = newVelocity;
        this.currentValue = newValue;
    }
}

