/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.util;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lsh/sit/plp/util/ColorUtils;", "", "<init>", "()V", "Ljava/util/UUID;", "uuid", "", "uuidToColor", "(Ljava/util/UUID;)I", "", "h", "s", "l", "hslToColor", "(FFF)I", "player-locator-plus"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();

    private ColorUtils() {
    }

    public final int uuidToColor(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Random random = RandomKt.Random((long)(uuid.getMostSignificantBits() ^ uuid.getLeastSignificantBits()));
        return this.hslToColor(random.nextFloat() * (float)360, random.nextFloat() / 4.0f + 0.75f, random.nextFloat() / 2.0f + 0.5f);
    }

    private final int hslToColor(float h, float s, float l) {
        float c = (float)(((double)1.0f - Math.abs((double)((float)2 * l - 1.0f))) * (double)s);
        float m = l - 0.5f * c;
        float x = (float)((double)c * ((double)1.0f - Math.abs((double)(h / 60.0f % 2.0f - 1.0f))));
        int hueSegment = (int)h / 60;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (hueSegment) {
            case 0: {
                r = Math.round((float)255 * (c + m));
                g = Math.round((float)255 * (x + m));
                b = Math.round((float)255 * m);
                break;
            }
            case 1: {
                r = Math.round((float)255 * (x + m));
                g = Math.round((float)255 * (c + m));
                b = Math.round((float)255 * m);
                break;
            }
            case 2: {
                r = Math.round((float)255 * m);
                g = Math.round((float)255 * (c + m));
                b = Math.round((float)255 * (x + m));
                break;
            }
            case 3: {
                r = Math.round((float)255 * m);
                g = Math.round((float)255 * (x + m));
                b = Math.round((float)255 * (c + m));
                break;
            }
            case 4: {
                r = Math.round((float)255 * (x + m));
                g = Math.round((float)255 * m);
                b = Math.round((float)255 * (c + m));
                break;
            }
            case 5: 
            case 6: {
                r = Math.round((float)255 * (c + m));
                g = Math.round((float)255 * m);
                b = Math.round((float)255 * (x + m));
            }
        }
        r = RangesKt.coerceIn((int)r, (int)0, (int)255);
        b = RangesKt.coerceIn((int)b, (int)0, (int)255);
        g = RangesKt.coerceIn((int)g, (int)0, (int)255);
        return r << 16 | g << 9 | b;
    }
}

