package sh.sit.plp.mixin;

import net.minecraft.class_329;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sh.sit.plp.PlayerLocatorPlusClient;

@Mixin(class_329.class)
public class InGameHudMixin {
    @Unique
    private float tickDelta = 0;

    @Inject(
        method = "render",
        at = @At(value = "HEAD")
    )
    private void beforeRender(class_332 context, float tickDelta, CallbackInfo ci) {
        // I know this is technically a very bad idea, but how else
        // should I get the tickDelta from renderExperienceBar?
        this.tickDelta = tickDelta;
    }

    @Inject(
        method = "renderStatusBars",
        at = @At(value = "HEAD")
    )
    private void beforeRenderStatusBars(class_332 context, CallbackInfo ci) {
        float offset = PlayerLocatorPlusClient.INSTANCE.getCurrentHudOffset();
        if (offset > 0) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, -offset, 0.0f);
        }
    }

    @Inject(
        method = "renderStatusBars",
        at = @At(value = "RETURN")
    )
    private void afterRenderStatusBars(class_332 context, CallbackInfo ci) {
        if (PlayerLocatorPlusClient.INSTANCE.getCurrentHudOffset() > 0) {
            context.method_51448().method_22909();
        }
    }

    @Inject(
        method = "renderExperienceBar",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiler/Profiler;pop()V", ordinal = 0)
    )
    private void beforeRenderExperienceLevel(class_332 context, int x, CallbackInfo ci) {
        PlayerLocatorPlusClient.INSTANCE.render(context, tickDelta);

        float offset = PlayerLocatorPlusClient.INSTANCE.getCurrentHudOffset();
        if (offset > 0) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, -offset, 0.0f);
        }
    }

    @Inject(
        method = "renderExperienceBar",
        at = @At(value = "RETURN")
    )
    private void afterRenderExperienceLevel(class_332 context, int x, CallbackInfo ci) {
        if (PlayerLocatorPlusClient.INSTANCE.getCurrentHudOffset() > 0) {
            context.method_51448().method_22909();
        }
    }

    @Inject(
        method = "render",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/ChatHud;render(Lnet/minecraft/client/gui/DrawContext;III)V")
    )
    private void beforeRenderChat(class_332 context, float tickDelta, CallbackInfo ci) {
        float offset = PlayerLocatorPlusClient.INSTANCE.getCurrentHudOffset();
        if (offset > 0) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, -offset, 0.0f);
        }
    }

    @Inject(
        method = "render",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/ChatHud;render(Lnet/minecraft/client/gui/DrawContext;III)V",
                 shift = At.Shift.AFTER)
    )
    private void afterRenderChat(class_332 context, float tickDelta, CallbackInfo ci) {
        if (PlayerLocatorPlusClient.INSTANCE.getCurrentHudOffset() > 0) {
            context.method_51448().method_22909();
        }
    }
}
