/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.util;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.math.MathKt;
import sh.sit.plp.kotlin_shaded.random.Random;
import sh.sit.plp.kotlin_shaded.random.RandomKt;
import sh.sit.plp.kotlin_shaded.ranges.RangesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lsh/sit/plp/util/ColorUtils;", "", "<init>", "()V", "uuidToColor", "", "uuid", "Ljava/util/UUID;", "hslToColor", "h", "", "s", "l", "player-locator-plus"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();

    private ColorUtils() {
    }

    public final int uuidToColor(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Random random = RandomKt.Random(uuid.getMostSignificantBits() ^ uuid.getLeastSignificantBits());
        return this.hslToColor(random.nextFloat() * (float)360, random.nextFloat() / 4.0f + 0.75f, random.nextFloat() / 2.0f + 0.5f);
    }

    private final int hslToColor(float h, float s, float l) {
        float c = (float)(((double)1.0f - Math.abs((double)((float)2 * l - 1.0f))) * (double)s);
        float m = l - 0.5f * c;
        float x = (float)((double)c * ((double)1.0f - Math.abs((double)(h / 60.0f % 2.0f - 1.0f))));
        int hueSegment = (int)h / 60;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (hueSegment) {
            case 0: {
                r = MathKt.roundToInt((float)255 * (c + m));
                g = MathKt.roundToInt((float)255 * (x + m));
                b = MathKt.roundToInt((float)255 * m);
                break;
            }
            case 1: {
                r = MathKt.roundToInt((float)255 * (x + m));
                g = MathKt.roundToInt((float)255 * (c + m));
                b = MathKt.roundToInt((float)255 * m);
                break;
            }
            case 2: {
                r = MathKt.roundToInt((float)255 * m);
                g = MathKt.roundToInt((float)255 * (c + m));
                b = MathKt.roundToInt((float)255 * (x + m));
                break;
            }
            case 3: {
                r = MathKt.roundToInt((float)255 * m);
                g = MathKt.roundToInt((float)255 * (x + m));
                b = MathKt.roundToInt((float)255 * (c + m));
                break;
            }
            case 4: {
                r = MathKt.roundToInt((float)255 * (x + m));
                g = MathKt.roundToInt((float)255 * m);
                b = MathKt.roundToInt((float)255 * (c + m));
                break;
            }
            case 5: 
            case 6: {
                r = MathKt.roundToInt((float)255 * (c + m));
                g = MathKt.roundToInt((float)255 * m);
                b = MathKt.roundToInt((float)255 * (x + m));
            }
        }
        r = RangesKt.coerceIn(r, 0, 255);
        b = RangesKt.coerceIn(b, 0, 255);
        g = RangesKt.coerceIn(g, 0, 255);
        return r << 16 | g << 9 | b;
    }
}

