package sh.sit.plp.mixin;

import com.mojang.brigadier.arguments.ArgumentType;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sh.sit.plp.color.ColorArgumentType;

@Mixin(class_2316.class)
public class ArgumentTypesMixin {
    @Inject(method = "getArgumentTypeProperties", at = @At("HEAD"), cancellable = true)
    private static <A extends ArgumentType<?>> void getArgumentTypeProperties(A argumentType, CallbackInfoReturnable<class_2314.class_7217<A>> cir) {
        if (argumentType instanceof ColorArgumentType) {
            // not unsafe, as argumentType (which is type A) is ColorArgumentType
            //noinspection unchecked
            cir.setReturnValue((class_2314.class_7217<A>)
                    ColorArgumentType.SERIALIZER.getArgumentTypeProperties(new ColorArgumentType()));
        }
    }
}
