/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.saveddata.SavedData;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonTime;

public class SeasonSavedData
extends SavedData {
    public static final Codec<SeasonSavedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("SeasonCycleTicks").orElse((Object)0).forGetter(o -> o.seasonCycleTicks)).apply((Applicative)builder, SeasonSavedData::new));
    public static final String DATA_IDENTIFIER = "seasons";
    public static final int VERSION = 0;
    public int seasonCycleTicks;

    public SeasonSavedData() {
        this(SeasonSavedData.calculateDefaultSeasonCycleTicks());
    }

    public SeasonSavedData(int seasonCycleTicks) {
        this.seasonCycleTicks = seasonCycleTicks;
    }

    private static int calculateDefaultSeasonCycleTicks() {
        int startingSeason = ModConfig.seasons.startingSubSeason;
        int seasonCycleTicks = 0;
        if (startingSeason > 0) {
            seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
        }
        return seasonCycleTicks;
    }
}

