/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sereneseasons.season.SeasonHooks;

@Mixin(value={Biome.class})
public class MixinBiome {
    @Inject(method={"shouldSnow"}, at={@At(value="HEAD")}, cancellable=true)
    public void onShouldSnow(LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)SeasonHooks.shouldSnowHook((Biome)this, level, pos, level.getSeaLevel()));
    }

    @Redirect(method={"shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Z)Z"}, at=@At(value="INVOKE", target="net/minecraft/world/level/biome/Biome.warmEnoughToRain(Lnet/minecraft/core/BlockPos;I)Z"))
    public boolean onShouldFreeze_warmEnoughToRain(Biome biome, BlockPos pos, int seaLevel, LevelReader level) {
        return SeasonHooks.shouldFreezeWarmEnoughToRainHook(biome, pos, seaLevel, level);
    }
}

