/*
 * Decompiled with CFR 0.152.
 */
package ru.kredwi.chathook;

import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class CheckDepends {
    private String[] dependsList = new String[]{"PlaceholderAPI"};
    private PluginManager pluginManager = Bukkit.getPluginManager();
    private Logger logger = Bukkit.getLogger();
    private Plugin plugin = null;

    protected CheckDepends(Plugin plugin) {
        this.plugin = plugin;
    }

    private boolean check(String pluginName) {
        return this.pluginManager.getPlugin(pluginName) != null;
    }

    protected void runCheckDepends() {
        String[] stringArray = this.dependsList;
        int n = this.dependsList.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginName = stringArray[n2];
            if (!this.check(pluginName)) {
                this.dependError(pluginName);
                return;
            }
            this.dependSucces(pluginName);
            ++n2;
        }
    }

    private void dependError(String pluginName) {
        this.logger.warning(String.format("Could not find %s! This plugin is required.", pluginName));
        this.pluginManager.disablePlugin(this.plugin);
    }

    private void dependSucces(String pluginName) {
        this.logger.info(String.format("%s is found", pluginName));
    }
}

