/*
 * Decompiled with CFR 0.152.
 */
package ru.kredwi.chathook;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.kredwi.chathook.CheckDepends;
import ru.kredwi.chathook.commands.MainCommand;
import ru.kredwi.chathook.events.ChatPlayerEvent;

public class Main
extends JavaPlugin {
    private FileConfiguration config;

    public void onLoad() {
        block5: {
            try {
                File configFile = new File(this.getDataFolder(), "config.yml");
                if (!configFile.exists()) {
                    configFile.getParentFile().mkdirs();
                    this.saveResource("config.yml", false);
                }
                this.config = YamlConfiguration.loadConfiguration((File)configFile);
                this.config.save(configFile);
                this.checkValidURL(this.config.getString("request_url"));
            }
            catch (MalformedURLException e) {
                Bukkit.getLogger().severe(String.format("URL IS ERROR: %s", e.getMessage()));
                if (this.config.getBoolean("debug")) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                this.getLogger().severe(e.getMessage());
                if (!this.config.getBoolean("debug")) break block5;
                e.printStackTrace();
            }
        }
    }

    public void onEnable() {
        new CheckDepends((Plugin)this).runCheckDepends();
        PluginCommand chatHook = this.getCommand("chathook");
        MainCommand mainCommand = new MainCommand((Plugin)this);
        chatHook.setExecutor((CommandExecutor)mainCommand);
        chatHook.setTabCompleter((TabCompleter)mainCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatPlayerEvent((Plugin)this), (Plugin)this);
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    private URL checkValidURL(String url) throws MalformedURLException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException(String.format("REQUEST URL %s IS NULL OR EMPTY", url));
        }
        return new URL(url);
    }
}

