/*
 * Decompiled with CFR 0.152.
 */
package ru.kredwi.chathook.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private Plugin plugin = null;
    private ConfigurationSection messages = null;

    public MainCommand(Plugin plugin) {
        this.plugin = plugin;
        this.messages = plugin.getConfig().getConfigurationSection("message_sector");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        this.messages = this.plugin.getConfig().getConfigurationSection("message_sector");
        if (!sender.hasPermission("chathook.use")) {
            sender.sendMessage(this.messages.getString("no_permissions"));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.messages.getString("no_arguments"));
            return true;
        }
        switch (args[0].trim().toLowerCase()) {
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage(this.messages.getString("config_is_reloaded"));
                return true;
            }
        }
        sender.sendMessage(this.messages.getString("error_invalid_command"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("reload");
        }
        return list.stream().filter(s -> s.startsWith(args[args.length - 1])).collect(Collectors.toList());
    }
}

