/*
 * Decompiled with CFR 0.152.
 */
package ru.kredwi.chathook.post.task;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.kredwi.chathook.post.model.PostBodyBuilder;
import ru.kredwi.chathook.post.model.RequestData;
import ru.kredwi.chathook.post.task.RequestUtil;

public class RequestTask
implements Runnable {
    private Plugin plugin = null;
    private Player player = null;
    private Gson gson = null;
    private boolean debug = false;
    private RequestData data = null;
    private PostBodyBuilder dataBody = new PostBodyBuilder();
    private RequestUtil requestUtil = null;

    public RequestTask(Plugin plugin, Player player, Gson gson, RequestData data) {
        this.plugin = plugin;
        this.player = player;
        this.gson = gson;
        this.data = data;
        this.requestUtil = new RequestUtil(plugin);
    }

    @Override
    public void run() {
        block15: {
            try {
                this.debug = this.plugin.getConfig().getBoolean("debug");
                String AuthToken = this.plugin.getConfig().getString("authorization");
                String body = this.dataBody.getBody(this.plugin, this.player, this.gson, this.data);
                byte[] input = body.getBytes();
                HttpURLConnection connection = this.requestUtil.formatConnection();
                connection.setRequestProperty("Content-Length", String.valueOf(input.length));
                if (!AuthToken.isEmpty()) {
                    connection.setRequestProperty("Authorization", AuthToken);
                }
                Throwable throwable = null;
                Object var6_10 = null;
                try (OutputStream os = connection.getOutputStream();){
                    os.write(input, 0, input.length);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                connection.connect();
                this.requestUtil.checkSuccess(connection.getResponseCode(), connection.getResponseMessage());
                connection.disconnect();
            }
            catch (UnknownHostException e) {
                Bukkit.getLogger().severe(String.format("Unknown Host:", e.getMessage()));
            }
            catch (ProtocolException e) {
                Bukkit.getLogger().severe(String.format("Unknown protocol:", e.getMessage()));
                Bukkit.getLogger().info("Maybe use http?");
            }
            catch (IOException e) {
                Bukkit.getLogger().severe(e.getMessage());
                if (!this.debug) break block15;
                e.printStackTrace();
            }
        }
    }
}

