/*
 * Decompiled with CFR 0.152.
 */
package ru.kredwi.chathook.post.task;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RequestUtil {
    private URL url = null;
    private int timeout = 5000;
    private boolean debug = false;
    private Plugin plugin;

    protected RequestUtil(Plugin plugin) {
        this.timeout = plugin.getConfig().getInt("timeout", 5000);
        this.plugin = plugin;
        this.debug = plugin.getConfig().getBoolean("debug");
        this.createURL();
    }

    private void createURL() {
        block2: {
            try {
                this.url = new URL(this.plugin.getConfig().getString("request_url"));
            }
            catch (MalformedURLException e) {
                Bukkit.getLogger().warning(e.getMessage());
                if (!this.debug) break block2;
                e.printStackTrace();
            }
        }
    }

    protected void checkSuccess(int responseCode, String responseMessage) {
        this.debug = this.plugin.getConfig().getBoolean("debug");
        if (responseCode != 200 && responseCode != 204) {
            Bukkit.getLogger().warning(String.format("Send POST WARN: (%s) %s", responseCode, responseMessage));
            Bukkit.getLogger().info(String.format("If the problem is not with the link, or the closed ports, or the wrong IP, please email me @Kredwi on github or another service", new Object[0]));
        } else if (this.debug) {
            Bukkit.getLogger().info(String.format("THE POST REQUEST HAS BEEN SUCCESSFULLY SENT TO THE ADDRESS: %S", this.url.toString()));
        }
    }

    protected HttpURLConnection formatConnection() throws ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setConnectTimeout(this.timeout);
        connection.setDoOutput(true);
        return connection;
    }
}

