/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.util.Providers;
import me.elian.ezauctions.EzAuctionsPlaceholderExpansion;
import me.elian.ezauctions.acf.PaperCommandManager;
import me.elian.ezauctions.bukkit.Metrics;
import me.elian.ezauctions.command.AuctionCommand;
import me.elian.ezauctions.command.BidCommand;
import me.elian.ezauctions.controller.AuctionController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.controller.ScoreboardController;
import me.elian.ezauctions.controller.UpdateController;
import me.elian.ezauctions.data.Database;
import me.elian.ezauctions.scheduler.BukkitTaskScheduler;
import me.elian.ezauctions.scheduler.TaskScheduler;
import me.elian.ezauctions.scheduler.ThreadedRegionTaskScheduler;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EzAuctions
extends JavaPlugin {
    private TaskScheduler scheduler;
    private Database database;
    private Metrics metrics;
    private AuctionController auctionController;
    private MessageController messageController;
    private ScoreboardController scoreboardController;
    private UpdateController updateController;
    private Injector injector;

    private static Class<? extends TaskScheduler> getSchedulerType() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            return ThreadedRegionTaskScheduler.class;
        }
        catch (ClassNotFoundException e) {
            return BukkitTaskScheduler.class;
        }
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void onEnable() {
        Economy economy = this.getEconomy();
        if (economy == null) {
            this.setEnabled(false);
            return;
        }
        Permission permission = this.getPermission();
        this.injector = this.createInjector(economy, permission, EzAuctions.getSchedulerType());
        this.registerCommands(this.injector);
        this.scheduler = this.injector.getInstance(TaskScheduler.class);
        this.database = this.injector.getInstance(Database.class);
        this.auctionController = this.injector.getInstance(AuctionController.class);
        this.messageController = this.injector.getInstance(MessageController.class);
        this.scoreboardController = this.injector.getInstance(ScoreboardController.class);
        this.metrics = new Metrics(this, 985);
        this.updateController = this.injector.getInstance(UpdateController.class);
        this.updateController.checkForUpdates();
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.injector.getInstance(EzAuctionsPlaceholderExpansion.class).register();
        }
    }

    public void onDisable() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.auctionController != null) {
            this.auctionController.shutdown();
        }
        if (this.messageController != null) {
            this.messageController.shutdown();
        }
        if (this.scoreboardController != null) {
            this.scoreboardController.shutdown();
        }
        if (this.updateController != null) {
            this.updateController.shutdown();
        }
        if (this.database != null) {
            this.database.shutdown();
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    private Economy getEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().severe("Vault plugin not Installed! Disabling ezAuctions...");
            return null;
        }
        ServicesManager servicesManager = this.getServer().getServicesManager();
        RegisteredServiceProvider rsp = servicesManager.getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().severe("Economy provider plugin not found! Make sure you have an economy provider plugin installed that supports Vault! Disabling ezAuctions...");
            return null;
        }
        return (Economy)rsp.getProvider();
    }

    private Permission getPermission() {
        ServicesManager servicesManager = this.getServer().getServicesManager();
        RegisteredServiceProvider rsp = servicesManager.getRegistration(Permission.class);
        if (rsp == null) {
            return null;
        }
        return (Permission)rsp.getProvider();
    }

    private Injector createInjector(Economy economy, Permission permission, Class<? extends TaskScheduler> schedulerClass) {
        EzAuctions plugin = this;
        PaperCommandManager commandManager = new PaperCommandManager((Plugin)plugin);
        return Guice.createInjector(new AbstractModule((Plugin)plugin, economy, commandManager, schedulerClass, permission){
            final /* synthetic */ Plugin val$plugin;
            final /* synthetic */ Economy val$economy;
            final /* synthetic */ PaperCommandManager val$commandManager;
            final /* synthetic */ Class val$schedulerClass;
            final /* synthetic */ Permission val$permission;
            {
                this.val$plugin = plugin;
                this.val$economy = economy;
                this.val$commandManager = paperCommandManager;
                this.val$schedulerClass = clazz;
                this.val$permission = permission;
            }

            @Override
            protected void configure() {
                this.bind(Plugin.class).toInstance(this.val$plugin);
                this.bind(Economy.class).toInstance(this.val$economy);
                this.bind(PaperCommandManager.class).toInstance(this.val$commandManager);
                this.bind(TaskScheduler.class).to(this.val$schedulerClass);
                if (this.val$permission == null) {
                    this.bind(Permission.class).toProvider(Providers.of(null));
                } else {
                    this.bind(Permission.class).toInstance(this.val$permission);
                }
            }
        });
    }

    private void registerCommands(Injector injector) {
        AuctionCommand auctionCommand = injector.getInstance(AuctionCommand.class);
        BidCommand bidCommand = injector.getInstance(BidCommand.class);
        PaperCommandManager manager = injector.getInstance(PaperCommandManager.class);
        manager.registerCommand(auctionCommand);
        manager.registerCommand(bidCommand);
    }
}

